/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainerGui;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;

public abstract class BlockContainerGuiCabled
extends ConfigurableBlockContainerGui {
    public BlockContainerGuiCabled(ExtendedConfig eConfig, Class<? extends CyclopsTileEntity> tileEntity) {
        super(eConfig, Material.field_151574_g, tileEntity);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && WrenchHelpers.isWrench(player, heldItem, world, pos, side) && player.func_70093_af()) {
            this.destroyBlock(world, pos, true);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        CableHelpers.onCableAdded(world, pos, placer);
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos) {
        CableHelpers.onCableRemoving(world, pos, true);
        super.onPreBlockDestroyed(world, pos);
    }

    protected void onPostBlockDestroyed(World world, BlockPos pos) {
        super.onPostBlockDestroyed(world, pos);
        CableHelpers.onCableRemoved(world, pos, CableHelpers.getExternallyConnectedCables(world, pos));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock);
    }
}

