/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.core.block.ICollidable;
import org.cyclops.integrateddynamics.core.block.ICollidableParent;

public class CollidableComponent<P, B extends Block>
implements ICollidable {
    private final B block;
    private final List<ICollidable.IComponent<P, B>> components;
    private final int totalComponents;
    private AxisAlignedBB lastBounds = Block.field_185505_j;

    public CollidableComponent(B block, List<ICollidable.IComponent<P, B>> components) {
        this.block = block;
        this.components = components;
        int count = 0;
        for (ICollidable.IComponent<P, B> component : components) {
            for (P position : component.getPossiblePositions()) {
                count += component.getBoundsCount(position);
            }
        }
        this.totalComponents = count;
    }

    private void addComponentCollisionBoxesToList(ICollidable.IComponent<EnumFacing, B> component, IBlockState state, World world, BlockPos pos, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> list, Entity collidingEntity) {
        for (EnumFacing position : component.getPossiblePositions()) {
            if (!component.isActive(this.getBlock(), world, pos, position)) continue;
            for (AxisAlignedBB bb : component.getBounds(this.getBlock(), world, pos, position)) {
                BlockHelpers.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)axisalignedbb, list, (AxisAlignedBB)bb);
            }
        }
    }

    @Override
    public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB axisalignedbb, List list, Entity collidingEntity, boolean useProvidedState) {
        for (ICollidable.IComponent<P, B> component : this.components) {
            this.addComponentCollisionBoxesToList(component, state, world, pos, axisalignedbb, list, collidingEntity);
        }
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState blockState, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        ICollidable.RayTraceResult raytraceResult = this.doRayTrace(world, pos, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        this.lastBounds = raytraceResult.getBoundingBox();
        return raytraceResult.getMovingObjectPosition();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBox(IBlockState blockState, World world, BlockPos pos) {
        return this.lastBounds.func_186670_a(pos);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.lastBounds;
    }

    public ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        if (player == null) {
            return null;
        }
        double reachDistance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0;
        double eyeHeight = world.field_72995_K ? (double)player.func_70047_e() : (double)player.func_70047_e();
        Vec3d lookVec = player.func_70040_Z();
        Vec3d origin = new Vec3d(player.field_70165_t, player.field_70163_u + eyeHeight, player.field_70161_v);
        Vec3d direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, pos, origin, direction);
    }

    private int doRayTraceComponent(ICollidable.IComponent<P, B> component, int countStart, World world, BlockPos pos, Vec3d origin, Vec3d direction, RayTraceResult[] hits, AxisAlignedBB[] boxes, P[] sideHit, ICollidable.IComponent<P, B>[] components) {
        int i = countStart;
        for (P position : component.getPossiblePositions()) {
            if (component.isActive(this.getBlock(), world, pos, position)) {
                int offset = 0;
                Iterator<AxisAlignedBB> iterator = component.getBounds(this.getBlock(), world, pos, position).iterator();
                while (iterator.hasNext()) {
                    AxisAlignedBB bb;
                    boxes[i + offset] = bb = iterator.next();
                    hits[i + offset] = ((ICollidableParent)this.getBlock()).rayTraceParent(pos, origin, direction, bb);
                    sideHit[i + offset] = position;
                    components[i + offset] = component;
                    ++offset;
                }
            }
            i += component.getBoundsCount(position);
        }
        return i;
    }

    private ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        RayTraceResult[] hits = new RayTraceResult[this.totalComponents];
        AxisAlignedBB[] boxes = new AxisAlignedBB[this.totalComponents];
        Object[] sideHit = new Object[this.totalComponents];
        ICollidable.IComponent[] componentsOutput = new ICollidable.IComponent[this.totalComponents];
        Arrays.fill(sideHit, null);
        int count = 0;
        for (ICollidable.IComponent<P, B> component : this.components) {
            count = this.doRayTraceComponent(component, count, world, pos, origin, direction, hits, boxes, sideHit, componentsOutput);
        }
        double minDistance = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double d;
            if (hits[i] == null || !((d = hits[i].field_72307_f.func_72436_e(origin)) < minDistance)) continue;
            minDistance = d;
            minIndex = i;
        }
        if (minIndex != -1) {
            return new ICollidable.RayTraceResult<Object>(hits[minIndex], boxes[minIndex], sideHit[minIndex], componentsOutput[minIndex]);
        }
        return null;
    }

    public B getBlock() {
        return this.block;
    }

    public List<ICollidable.IComponent<P, B>> getComponents() {
        return this.components;
    }

    public int getTotalComponents() {
        return this.totalComponents;
    }

    public AxisAlignedBB getLastBounds() {
        return this.lastBounds;
    }

    public void setLastBounds(AxisAlignedBB lastBounds) {
        this.lastBounds = lastBounds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollidableComponent)) {
            return false;
        }
        CollidableComponent other = (CollidableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        B this$block = this.getBlock();
        B other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        List<ICollidable.IComponent<P, B>> this$components = this.getComponents();
        List<ICollidable.IComponent<P, B>> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        if (this.getTotalComponents() != other.getTotalComponents()) {
            return false;
        }
        AxisAlignedBB this$lastBounds = this.getLastBounds();
        AxisAlignedBB other$lastBounds = other.getLastBounds();
        return !(this$lastBounds == null ? other$lastBounds != null : !this$lastBounds.equals(other$lastBounds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollidableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        B $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        List<ICollidable.IComponent<P, B>> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        result = result * 59 + this.getTotalComponents();
        AxisAlignedBB $lastBounds = this.getLastBounds();
        result = result * 59 + ($lastBounds == null ? 43 : $lastBounds.hashCode());
        return result;
    }

    public String toString() {
        return "CollidableComponent(block=" + this.getBlock() + ", components=" + this.getComponents() + ", totalComponents=" + this.getTotalComponents() + ", lastBounds=" + this.getLastBounds() + ")";
    }
}

