/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.subgui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;

@SideOnly(value=Side.CLIENT)
public abstract class SubGuiBox
extends Gui
implements ISubGuiBox {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("integrateddynamics", (String)IntegratedDynamics._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "sub_gui.png");
    private final Box type;
    protected List<GuiButton> buttonList = Lists.newArrayList();
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();

    public SubGuiBox(Box type) {
        this.type = type;
    }

    @Override
    public void initGui(int guiLeft, int guiTop) {
        this.buttonList.clear();
        this.subGuiHolder.initGui(guiLeft, guiTop);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
        int currentHeight;
        int i;
        int currentWidth;
        int textureWidth;
        textureManager.func_110577_a(TEXTURE);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int textureHeight = textureWidth = 19;
        int x = guiLeft + this.getX();
        int y = guiTop + this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int tx = this.type.getX();
        int ty = this.type.getY();
        this.func_73729_b(x, y, tx, tx, 1, 1);
        this.func_73729_b(x + width - 1, y, tx + textureWidth - 1, ty, 1, 1);
        this.func_73729_b(x, y + height - 1, 0, tx + textureHeight - 1, ty + 1, 1);
        this.func_73729_b(x + width - 1, y + height - 1, tx + textureWidth - 1, ty + textureHeight - 1, 1, 1);
        for (i = 1; i < width - 1; i += currentWidth) {
            currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
            this.func_73729_b(x + i, y, tx + 1, ty, currentWidth, 1);
            this.func_73729_b(x + i, y + height - 1, tx + 1, ty + textureHeight - 1, currentWidth, 1);
        }
        for (i = 1; i < height - 1; i += currentHeight) {
            currentHeight = Math.max(1, Math.min(height - i, textureHeight - 2) - 1);
            this.func_73729_b(x, y + i, tx, ty + 1, 1, currentHeight);
            this.func_73729_b(x + width - 1, y + i, tx + textureWidth - 1, ty + 1, 1, currentHeight);
        }
        for (i = 1; i < width - 1; i += currentWidth) {
            int currentHeight2;
            currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
            for (int j = 1; j < height - 1; j += currentHeight2) {
                currentHeight2 = Math.max(1, Math.min(height - j, textureHeight - 2) - 1);
                this.func_73729_b(x + i, y + j, tx + 1, ty + 1, currentWidth, currentHeight2);
            }
        }
        this.drawScreen(mouseX, mouseY, partialTicks);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
    }

    @Override
    public boolean keyTyped(boolean checkHotbarKeys, char typedChar, int keyCode) throws IOException {
        return this.subGuiHolder.keyTyped(checkHotbarKeys, typedChar, keyCode);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            GuiButton guibutton = this.buttonList.get(i);
            if (!guibutton.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) continue;
            guibutton.func_146113_a(Minecraft.func_71410_x().func_147118_V());
            this.actionPerformed(guibutton);
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public static class Base
    extends SubGuiBox {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public Base(Box type, int x, int y, int width, int height) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
        }

        @Override
        public boolean keyTyped(boolean checkHotbarKeys, char typedChar, int keyCode) throws IOException {
            return false;
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getX() != other.getX()) {
                return false;
            }
            if (this.getY() != other.getY()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getHeight() == other.getHeight();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getX();
            result = result * 59 + this.getY();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            return result;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return "SubGuiBox.Base(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }

    public static enum Box {
        LIGHT(0, 0),
        DARK(0, 19);

        private final int x;
        private final int y;

        private Box(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

