/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.ITransformation;

public final class ModelHelpers {
    public static final ModelBlock MODEL_GENERATED = ModelBlock.func_178294_a((String)"{\"elements\":[{  \"from\": [0, 0, 0],   \"to\": [16, 16, 16],   \"faces\": {       \"down\": {\"uv\": [0, 0, 16, 16], \"texture\":\"\"}   }}]}");
    public static final ItemModelGenerator MODEL_GENERATOR = new ItemModelGenerator();
    public static final FaceBakery FACE_BAKERY = new FaceBakery();

    public static ModelBlock loadModelBlock(ResourceLocation modelLocation) throws IOException {
        IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(resource.func_110527_b(), Charsets.UTF_8);
        return ModelBlock.func_178307_a((Reader)reader);
    }

    public static IBakedModel bakeModel(ModelBlock model, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation(model.func_178308_c("layer0")));
        return ModelHelpers.bakeModel(model, sprite, (ITransformation)ModelRotation.X0_Y0);
    }

    public static IBakedModel bakeModel(ModelBlock model, TextureAtlasSprite icon, ITransformation transformation) {
        ModelBlock itemModel = MODEL_GENERATOR.func_178392_a(Minecraft.func_71410_x().func_147117_R(), model);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(itemModel, itemModel.func_187967_g());
        itemModel.field_178318_c.put("layer0", icon.func_94215_i());
        builder.func_177646_a(icon);
        for (BlockPart blockPart : itemModel.func_178298_a()) {
            for (EnumFacing side : blockPart.field_178240_c.keySet()) {
                BlockPartFace blockPartFace = (BlockPartFace)blockPart.field_178240_c.get(side);
                builder.func_177648_a(ModelHelpers.makeBakedQuad(blockPart, blockPartFace, icon, side, transformation, false));
            }
        }
        return builder.func_177645_b();
    }

    protected static BakedQuad makeBakedQuad(BlockPart blockPart, BlockPartFace blockPartFace, TextureAtlasSprite icon, EnumFacing side, ITransformation transformation, boolean shade) {
        return FACE_BAKERY.makeBakedQuad(blockPart.field_178241_a, blockPart.field_178239_b, blockPartFace, icon, side, transformation, blockPart.field_178237_d, shade, blockPart.field_178238_e);
    }
}

