/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class GeneralChoiceOperator
extends GeneralOperator {
    public GeneralChoiceOperator(String symbol, String operatorName) {
        super(symbol, operatorName, new IValueType[]{ValueTypes.BOOLEAN, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY}, ValueTypes.CATEGORY_ANY, new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                boolean a = ((ValueTypeBoolean.ValueBoolean)variables.getValue(0)).getRawValue();
                return a ? variables.getValue(1) : variables.getValue(2);
            }
        }, new IConfigRenderPattern.Base(100, 22, new Pair[]{Pair.of((Object)6, (Object)2), Pair.of((Object)60, (Object)2), Pair.of((Object)80, (Object)2)}, (Pair<Integer, Integer>)Pair.of((Object)40, (Object)2)));
    }

    @Override
    public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
        int requiredInputLength = this.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_input_length", new Object[]{this.getOperatorName(), input.length, requiredInputLength});
        }
        IValueType temporarySecondInputType = null;
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType == null) {
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.null_type", new Object[]{this.getOperatorName(), Integer.toString(i)});
            }
            if (i == 0 && this.getInputTypes()[i] != inputType) {
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_type", new Object[]{this.getOperatorName(), new L10NHelpers.UnlocalizedString(inputType.getUnlocalizedName(), new Object[0]), Integer.toString(i), new L10NHelpers.UnlocalizedString(this.getInputTypes()[i].getUnlocalizedName(), new Object[0])});
            }
            if (i == 1) {
                temporarySecondInputType = inputType;
                continue;
            }
            if (i != 2 || ValueHelpers.correspondsTo(temporarySecondInputType, inputType)) continue;
            return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_type", new Object[]{this.getOperatorName(), new L10NHelpers.UnlocalizedString(inputType.getUnlocalizedName(), new Object[0]), Integer.toString(i), new L10NHelpers.UnlocalizedString(temporarySecondInputType.getUnlocalizedName(), new Object[0])});
        }
        return null;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return input[1].getType();
    }
}

