/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.build.OperatorBuilder;
import org.cyclops.integrateddynamics.core.evaluate.operator.CombinedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CompositionalOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralChoiceOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralIdentityOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyAppend;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyConcat;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityArmorInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyLazyBuilt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyOperatorMapped;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxySlice;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyTail;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.helper.obfuscation.ObfuscationHelpers;

public final class Operators {
    public static final IOperatorRegistry REGISTRY = Operators.constructRegistry();
    public static final IOperator LOGICAL_AND = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("&&").operatorName("and").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeBoolean.ValueBoolean a = (ValueTypeBoolean.ValueBoolean)variables.getValue(0);
            if (!a.getRawValue()) {
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return variables.getValue(1);
        }
    }).build());
    public static final IOperator LOGICAL_OR = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("||").operatorName("or").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeBoolean.ValueBoolean a = (ValueTypeBoolean.ValueBoolean)variables.getValue(0);
            if (a.getRawValue()) {
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return variables.getValue(1);
        }
    }).build());
    public static final IOperator LOGICAL_NOT = REGISTRY.register(OperatorBuilders.LOGICAL_1_PREFIX.symbol("!").operatorName("not").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(!((ValueTypeBoolean.ValueBoolean)variables.getValue(0)).getRawValue());
        }
    }).build());
    public static final IOperator LOGICAL_NAND = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_AND).build("!&&", "nand", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator LOGICAL_NOR = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_OR).build("!||", "nor", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator ARITHMETIC_ADDITION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("+").operatorName("addition").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.add(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_SUBTRACTION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("-").operatorName("subtraction").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.subtract(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MULTIPLICATION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("*").operatorName("multiplication").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.multiply(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_DIVISION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("/").operatorName("division").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.divide(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MAXIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("max").operatorName("maximum").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.max(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MINIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("min").operatorName("minimum").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.min(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    private static final ValueTypeInteger.ValueInteger ZERO = ValueTypeInteger.ValueInteger.of(0);
    public static final IOperator INTEGER_MODULUS = REGISTRY.register(OperatorBuilders.INTEGER_2.symbol("%").operatorName("modulus").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            if (b.getRawValue() == 0) {
                throw new EvaluationException("Division by zero");
            }
            if (b.getRawValue() == 1) {
                return ZERO;
            }
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() % b.getRawValue());
        }
    }).build());
    public static final IOperator INTEGER_INCREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("++").operatorName("increment").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() + 1);
        }
    }).build());
    public static final IOperator INTEGER_DECREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("--").operatorName("decrement").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() - 1);
        }
    }).build());
    public static final IOperator RELATIONAL_EQUALS = REGISTRY.register(OperatorBuilders.RELATIONAL.inputTypes(2, (IValueType)ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbol("==").operatorName("equals").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(variables.getValue(0).equals(variables.getValue(1)));
        }
    }).typeValidator(new OperatorBuilder.ITypeValidator(){

        @Override
        public L10NHelpers.UnlocalizedString validateTypes(OperatorBase operator, IValueType[] input) {
            int requiredInputLength = operator.getRequiredInputLength();
            if (input.length != requiredInputLength) {
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_input_length", new Object[]{operator.getOperatorName(), input.length, requiredInputLength});
            }
            IValueType temporarySecondInputType = null;
            for (int i = 0; i < requiredInputLength; ++i) {
                IValueType inputType = input[i];
                if (inputType instanceof IValueTypeNumber) {
                    inputType = ValueTypes.CATEGORY_NUMBER;
                }
                if (inputType == null) {
                    return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.null_type", new Object[]{operator.getOperatorName(), Integer.toString(i)});
                }
                if (i == 0) {
                    temporarySecondInputType = inputType;
                    continue;
                }
                if (i != 1 || temporarySecondInputType == inputType) continue;
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_type", new Object[]{operator.getOperatorName(), new L10NHelpers.UnlocalizedString(inputType.getUnlocalizedName(), new Object[0]), Integer.toString(i), new L10NHelpers.UnlocalizedString(temporarySecondInputType.getUnlocalizedName(), new Object[0])});
            }
            return null;
        }
    }).build());
    public static final IOperator RELATIONAL_GT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol(">").operatorName("gt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.greaterThan(variables.getVariables()[0], variables.getVariables()[1]));
        }
    }).build());
    public static final IOperator RELATIONAL_LT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol("<").operatorName("lt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.lessThan(variables.getVariables()[0], variables.getVariables()[1]));
        }
    }).build());
    public static final IOperator RELATIONAL_NOTEQUALS = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(RELATIONAL_EQUALS).build("!=", "notequals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_GE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_GT).build(">=", "ge", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_LE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_LT).build("<=", "le", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator BINARY_AND = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("&").operatorName("and").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() & b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_OR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("|").operatorName("or").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() | b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_XOR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("^").operatorName("xor").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() ^ b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_COMPLEMENT = REGISTRY.register(OperatorBuilders.BINARY_1_PREFIX.symbol("~").operatorName("complement").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(~a.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_LSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("<<").operatorName("lshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() << b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_RSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>").operatorName("rshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() >> b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_RZSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>>").operatorName("rzshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() >>> b.getRawValue());
        }
    }).build());
    public static final IOperator STRING_LENGTH = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.symbol("len").operatorName("length").output(ValueTypes.INTEGER).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue().length());
        }
    }).build());
    public static final IOperator STRING_CONCAT = REGISTRY.register(OperatorBuilders.STRING_2.symbol("+").operatorName("concat").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            ValueTypeString.ValueString b = (ValueTypeString.ValueString)variables.getValue(1);
            return ValueTypeString.ValueString.of(a.getRawValue() + b.getRawValue());
        }
    }).build());
    public static final IOperator NAMED_NAME = REGISTRY.register(OperatorBuilders.STRING_2.symbol("name").operatorName("name").inputType(ValueTypes.CATEGORY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeString.ValueString.of(ValueTypes.CATEGORY_NAMED.getName(variables.getVariables()[0]));
        }
    }).build());
    public static final IOperator DOUBLE_ROUND = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("|| ||").operatorName("round").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.round(a.getRawValue()));
        }
    }).build());
    public static final IOperator DOUBLE_CEIL = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("\u2308 \u2309").operatorName("ceil").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.ceil(a.getRawValue()));
        }
    }).build());
    public static final IOperator DOUBLE_FLOOR = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("\u230a \u230b").operatorName("floor").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.floor(a.getRawValue()));
        }
    }).build());
    public static final IOperator NULLABLE_ISNULL = REGISTRY.register(OperatorBuilders.NULLABLE_1_PREFIX.symbol("o").operatorName("isnull").inputType(ValueTypes.CATEGORY_ANY).output(ValueTypes.BOOLEAN).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            if (ValueHelpers.correspondsTo(variables.getVariables()[0].getType(), ValueTypes.CATEGORY_NULLABLE)) {
                return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NULLABLE.isNull(variables.getVariables()[0]));
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
    }).build());
    public static final IOperator NULLABLE_ISNOTNULL = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(NULLABLE_ISNULL).build("\u2205", "isnotnull", IConfigRenderPattern.PREFIX_1, "general"));
    public static final IOperator LIST_LENGTH = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.INTEGER).symbol("| |").operatorName("length").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            return ValueTypeInteger.ValueInteger.of(a.getLength());
        }
    }).build());
    public static final IOperator LIST_EMPTY = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.BOOLEAN).symbol("\u2205").operatorName("empty").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            return ValueTypeBoolean.ValueBoolean.of(a.getLength() == 0);
        }
    }).build());
    public static final IOperator LIST_NOT_EMPTY = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LIST_EMPTY).build("o", "notempty", IConfigRenderPattern.PREFIX_1, "list"));
    public static final IOperator LIST_ELEMENT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbolOperator("get").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            if (b.getRawValue() < a.getLength()) {
                return a.get(b.getRawValue());
            }
            return a.getValueType().getDefault();
        }
    }).conditionalOutputTypeDeriver(new OperatorBuilder.IConditionalOutputTypeDeriver(){

        @Override
        public IValueType getConditionalOutputType(OperatorBase operator, IVariable[] input) {
            try {
                IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
                return a.getValueType();
            }
            catch (EvaluationException e) {
                return operator.getConditionalOutputType(input);
            }
        }
    }).build());
    public static final IOperator LIST_CONTAINS = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_2_LONG).output(ValueTypes.BOOLEAN).symbolOperator("contains").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            Object input = variables.getValue(1);
            for (IValue value : list) {
                if (!value.equals(input)) continue;
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
    }).build());
    public static final IOperator LIST_CONTAINS_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.BOOLEAN).symbolOperator("contains_p").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            IOperator operator = OperatorBuilders.getSafePredictate((ValueTypeOperator.ValueOperator)variables.getValue(1));
            for (IValue value : list) {
                IValue result = operator.evaluate(new Variable<IValue>(value.getType(), value));
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
    }).build());
    public static final IOperator LIST_COUNT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperator("count").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            Object value = variables.getValue(1);
            int count = 0;
            for (IValue listValue : list) {
                if (!listValue.equals(value)) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_COUNT_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperator("count_p").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            IOperator operator = OperatorBuilders.getSafePredictate((ValueTypeOperator.ValueOperator)variables.getValue(1));
            int count = 0;
            for (IValue listValue : list) {
                IValue result = operator.evaluate(new Variable<IValue>(listValue.getType(), listValue));
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_APPEND = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("append").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            Object value = variables.getValue(1);
            if (!ValueHelpers.correspondsTo(a.getValueType(), value.getType())) {
                L10NHelpers.UnlocalizedString error = new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{a.getValueType(), value.getType()});
                throw new EvaluationException(error.localize());
            }
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyAppend(a, value));
        }
    }).build());
    public static final IOperator LIST_CONCAT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.LIST).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("concat").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            IValueTypeListProxy b = ((ValueTypeList.ValueList)variables.getValue(1)).getRawValue();
            if (!ValueHelpers.correspondsTo(a.getValueType(), b.getValueType())) {
                L10NHelpers.UnlocalizedString error = new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{a.getValueType(), b.getValueType()});
                throw new EvaluationException(error.localize());
            }
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyConcat(a, b));
        }
    }).build());
    public static final IOperator LIST_LAZYBUILT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.CATEGORY_ANY, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("lazybuilt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object a = variables.getValue(0);
            IOperator operator = OperatorBuilders.getSafeOperator((ValueTypeOperator.ValueOperator)variables.getValue(1), a.getType());
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyLazyBuilt(a, operator));
        }
    }).build());
    public static final IOperator LIST_HEAD = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).symbolOperator("head").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            if (a.getLength() > 0) {
                return a.get(0);
            }
            return a.getValueType().getDefault();
        }
    }).conditionalOutputTypeDeriver(new OperatorBuilder.IConditionalOutputTypeDeriver(){

        @Override
        public IValueType getConditionalOutputType(OperatorBase operator, IVariable[] input) {
            try {
                IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
                return a.getValueType();
            }
            catch (EvaluationException e) {
                return operator.getConditionalOutputType(input);
            }
        }
    }).build());
    public static final IOperator LIST_TAIL = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperator("tail").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyTail(a));
        }
    }).build());
    public static final IOperator LIST_UNIQ_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("uniq_p").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            final IOperator operator = OperatorBuilders.getSafePredictate((ValueTypeOperator.ValueOperator)variables.getValue(1));
            TreeSet values = Sets.newTreeSet((Comparator)new Comparator<IValue>(){

                @Override
                public int compare(IValue o1, IValue o2) {
                    ValueTypeBoolean.ValueBoolean value = (ValueTypeBoolean.ValueBoolean)operator.evaluate(new Variable<IValue>(o1), new Variable<IValue>(o2));
                    return value.getRawValue() ? 0 : o1.hashCode() - o2.hashCode();
                }
            });
            for (IValue value : list) {
                values.add(value);
            }
            return ValueTypeList.ValueList.ofList(list.getValueType(), Lists.newArrayList((Iterable)values));
        }
    }).build());
    public static final IOperator LIST_UNIQ = REGISTRY.register(OperatorBuilders.LIST.inputType(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperator("uniq").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            TreeSet values = Sets.newTreeSet((Comparator)new Comparator<IValue>(){

                @Override
                public int compare(IValue o1, IValue o2) {
                    return o1.equals(o2) ? 0 : o1.hashCode() - o2.hashCode();
                }
            });
            for (IValue value : list) {
                values.add(value);
            }
            return ValueTypeList.ValueList.ofList(list.getValueType(), Lists.newArrayList((Iterable)values));
        }
    }).build());
    public static final IOperator LIST_SLICE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER, ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.PREFIX_3_LONG).output(ValueTypes.LIST).symbolOperator("slice").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy list = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            ValueTypeInteger.ValueInteger from = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            ValueTypeInteger.ValueInteger to = (ValueTypeInteger.ValueInteger)variables.getValue(2);
            if (from.getRawValue() >= to.getRawValue()) {
                throw new EvaluationException("The 'from' value must be stricly smaller than the 'to' value in the slice operator.");
            }
            if (from.getRawValue() < 0 || to.getRawValue() < 0) {
                throw new EvaluationException("The 'from' and 'to' values in the slice operator must not be negative.");
            }
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxySlice(list, from.getRawValue(), to.getRawValue()));
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_OPAQUE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("opaque").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_185914_p());
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_ITEMSTACK = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemstack").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueObjectTypeItemStack.ValueItemStack.of(a.getRawValue().isPresent() ? BlockHelpers.getItemStackFromBlockState((IBlockState)((IBlockState)a.getRawValue().get())) : null);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_MODNAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{new IOperatorValuePropagator<OperatorBase.SafeVariablesGetter, ResourceLocation>(){

        @Override
        public ResourceLocation getOutput(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return a.getRawValue().isPresent() ? (ResourceLocation)Block.field_149771_c.func_177774_c((Object)((IBlockState)a.getRawValue().get()).func_177230_c()) : null;
        }
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_BLOCK_BREAKSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("breaksound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<SoundType>, String>(){

        @Override
        public String getOutput(Optional<SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((SoundType)sound.get()).func_185845_c().func_187503_a().toString();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_PLACESOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("placesound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<SoundType>, String>(){

        @Override
        public String getOutput(Optional<SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((SoundType)sound.get()).func_185841_e().func_187503_a().toString();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_STEPSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("stepsound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<SoundType>, String>(){

        @Override
        public String getOutput(Optional<SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((SoundType)sound.get()).func_185844_d().func_187503_a().toString();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_ISSHEARABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isshearable").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_177230_c() instanceof IShearable && ((IShearable)((IBlockState)a.getRawValue().get()).func_177230_c()).isShearable(null, null, null));
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isplantable").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTTYPE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("planttype").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            String type = "None";
            if (a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable) {
                type = ((IPlantable)((IBlockState)a.getRawValue().get()).func_177230_c()).getPlantType(null, null).name();
            }
            return ValueTypeString.ValueString.of(type);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANT = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("plant").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            IBlockState plant = null;
            if (a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_177230_c() instanceof IPlantable) {
                plant = ((IPlantable)((IBlockState)a.getRawValue().get()).func_177230_c()).getPlant(null, null);
            }
            return ValueObjectTypeBlock.ValueBlock.of(plant);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTAGE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("plantage").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            int age = 0;
            if (a.getRawValue().isPresent()) {
                for (IProperty prop : ((IBlockState)a.getRawValue().get()).func_177228_b().keySet()) {
                    if (!prop.func_177701_a().equals("age") || prop.func_177699_b() != Integer.class) continue;
                    age = (Integer)((IBlockState)a.getRawValue().get()).func_177229_b(prop);
                }
            }
            return ValueTypeInteger.ValueInteger.of(age);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_BY_NAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_BLOCK).symbolOperator("blockbyname").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(new IOperatorValuePropagator<Pair<ResourceLocation, Integer>, IValue>(){

        @Override
        public IValue getOutput(Pair<ResourceLocation, Integer> input) throws EvaluationException {
            Block block = (Block)Block.field_149771_c.func_82594_a(input.getLeft());
            IBlockState blockState = null;
            if (block != null) {
                blockState = block.func_176203_a(((Integer)input.getRight()).intValue());
            }
            return ValueObjectTypeBlock.ValueBlock.of(blockState);
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_SIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("size").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? itemStack.func_190916_E() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxsize").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? itemStack.func_77976_d() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISSTACKABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("stackable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() && itemStack.func_77985_e();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISDAMAGEABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("damageable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() && itemStack.func_77984_f();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_DAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("damage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? itemStack.func_77952_i() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXDAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxdamage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? itemStack.func_77958_k() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTED = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchanted").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() && itemStack.func_77948_v();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchantable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() && itemStack.func_77956_u();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_REPAIRCOST = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("repaircost").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? itemStack.func_82838_A() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_RARITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueTypeString.ValueString.of(!a.getRawValue().func_190926_b() ? a.getRawValue().func_77953_t().field_77934_f : "");
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.DOUBLE).symbolOperator("strength").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ValueObjectTypeBlock.ValueBlock b = (ValueObjectTypeBlock.ValueBlock)variables.getValue(1);
            return ValueTypeDouble.ValueDouble.of(!a.getRawValue().func_190926_b() && b.getRawValue().isPresent() ? (double)a.getRawValue().func_150997_a((IBlockState)b.getRawValue().get()) : 0.0);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.BOOLEAN).symbolOperator("canharvest").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ValueObjectTypeBlock.ValueBlock b = (ValueObjectTypeBlock.ValueBlock)variables.getValue(1);
            return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && b.getRawValue().isPresent() && a.getRawValue().func_150998_b((IBlockState)b.getRawValue().get()));
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueObjectTypeBlock.ValueBlock.of(!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof ItemBlock ? BlockHelpers.getBlockStateFromItemStack((ItemStack)a.getRawValue()) : null);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isfluidstack").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() && Helpers.getFluidStack(itemStack) != null;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_FLUIDSTACK).symbolOperator("fluidstack").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueObjectTypeFluidStack.ValueFluidStack.of(!a.getRawValue().func_190926_b() ? Helpers.getFluidStack(a.getRawValue()) : null);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("fluidstackcapacity").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? Helpers.getFluidStackCapacity(itemStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISNBTEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NBT=").operatorName("isnbtequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ItemStack a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
            ItemStack b = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (!a.func_190926_b() && !b.func_190926_b()) {
                equal = a.func_77969_a(b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
            } else if (a.func_190926_b() && b.func_190926_b()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISITEMEQUALNONBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NoNBT=").operatorName("isitemequalnonbt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ItemStack a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
            ItemStack b = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (!a.func_190926_b() && !b.func_190926_b()) {
                equal = ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
            } else if (a.func_190926_b() && b.func_190926_b()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISRAWITEMEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwitemequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ItemStack a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
            ItemStack b = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (!a.func_190926_b() && !b.func_190926_b()) {
                equal = ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
            } else if (a.func_190926_b() && b.func_190926_b()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_MODNAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{new IOperatorValuePropagator<OperatorBase.SafeVariablesGetter, ResourceLocation>(){

        @Override
        public ResourceLocation getOutput(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return !a.getRawValue().func_190926_b() ? (ResourceLocation)Item.field_150901_e.func_177774_c((Object)a.getRawValue().func_77973_b()) : null;
        }
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_ITEMSTACK_FUELBURNTIME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("burntime").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return !itemStack.func_190926_b() ? TileEntityFurnace.func_145952_a((ItemStack)itemStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_CANBURN = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("canburn").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_CANSMELT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("cansmelt").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && !FurnaceRecipes.func_77602_a().func_151395_a(itemStack).func_190926_b();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_OREDICT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("oredict").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (!a.getRawValue().func_190926_b()) {
                for (int i : OreDictionary.getOreIDs((ItemStack)a.getRawValue())) {
                    builder.add((Object)ValueTypeString.ValueString.of(OreDictionary.getOreName((int)i)));
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, builder.build());
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_OREDICT_STACKS = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.output(ValueTypes.LIST).symbolOperator("oredict").inputType(ValueTypes.STRING).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (!StringUtils.func_151246_b((String)a.getRawValue())) {
                for (ItemStack itemStack : OreDictionary.getOres((String)a.getRawValue())) {
                    builder.add((Object)ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, builder.build());
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_WITHSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_INTEGER_1.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("withsize").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            if (!a.getRawValue().func_190926_b()) {
                ItemStack itemStack = a.getRawValue().func_77946_l();
                itemStack.func_190920_e(b.getRawValue());
                return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
            }
            return a;
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFECONTAINER = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isfecontainer").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_BOOLEAN.build(new IOperatorValuePropagator<IEnergyStorage, Boolean>(){

        @Override
        public Boolean getOutput(IEnergyStorage input) throws EvaluationException {
            return input != null;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_STOREDFE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("storedfe").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(new IOperatorValuePropagator<IEnergyStorage, Integer>(){

        @Override
        public Integer getOutput(IEnergyStorage input) throws EvaluationException {
            return input != null ? input.getEnergyStored() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_FECAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("fecapacity").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(new IOperatorValuePropagator<IEnergyStorage, Integer>(){

        @Override
        public Integer getOutput(IEnergyStorage input) throws EvaluationException {
            return input != null ? input.getMaxEnergyStored() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_HASINVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("hasinventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && a.getRawValue().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isplantable").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof IPlantable);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORYSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("inventorysize").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            int size = 0;
            if (!a.getRawValue().func_190926_b() && a.getRawValue().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler itemHandler = (IItemHandler)a.getRawValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                size = itemHandler.getSlots();
            }
            return ValueTypeInteger.ValueInteger.of(size);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANTTYPE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("planttype").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            String type = "None";
            if (!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof IPlantable) {
                type = ((IPlantable)a.getRawValue().func_77973_b()).getPlantType(null, null).name();
            }
            return ValueTypeString.ValueString.of(type);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            if (!a.getRawValue().func_190926_b() && a.getRawValue().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler itemHandler = (IItemHandler)a.getRawValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                ArrayList values = Lists.newArrayListWithCapacity((int)itemHandler.getSlots());
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    values.add(ValueObjectTypeItemStack.ValueItemStack.of(itemHandler.getStackInSlot(i)));
                }
                return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, values);
            }
            return ValueTypes.LIST.getDefault();
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("plant").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            IBlockState plant = null;
            if (!a.getRawValue().func_190926_b() && a.getRawValue().func_77973_b() instanceof IPlantable) {
                plant = ((IPlantable)a.getRawValue().func_77973_b()).getPlant(null, null);
            }
            return ValueObjectTypeBlock.ValueBlock.of(plant);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BY_NAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itembyname").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(new IOperatorValuePropagator<Pair<ResourceLocation, Integer>, IValue>(){

        @Override
        public IValue getOutput(Pair<ResourceLocation, Integer> input) throws EvaluationException {
            Item item = (Item)Item.field_150901_e.func_82594_a(input.getLeft());
            ItemStack itemStack = ItemStack.field_190927_a;
            if (item != null) {
                itemStack = new ItemStack(item, 1, ((Integer)input.getRight()).intValue());
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_LIST_COUNT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(ValueTypes.LIST, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.INTEGER).symbolOperator("itemlistcount").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeList.ValueList a = (ValueTypeList.ValueList)variables.getValue(0);
            ValueObjectTypeItemStack.ValueItemStack b = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1);
            if (!ValueHelpers.correspondsTo(a.getRawValue().getValueType(), ValueTypes.OBJECT_ITEMSTACK)) {
                L10NHelpers.UnlocalizedString error = new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{a.getRawValue().getValueType(), ValueTypes.OBJECT_ITEMSTACK});
                throw new EvaluationException(error.localize());
            }
            ItemStack itemStack = b.getRawValue();
            int count = 0;
            for (ValueObjectTypeItemStack.ValueItemStack listValue : a.getRawValue()) {
                if (listValue.getRawValue().func_190926_b()) continue;
                ItemStack listItem = listValue.getRawValue();
                if (!itemStack.func_190926_b()) {
                    if (!itemStack.func_77969_a(listItem) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)listItem)) continue;
                    count += listItem.func_190916_E();
                    continue;
                }
                count += listItem.func_190916_E();
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_ISMOB = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("ismob").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof IMob;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISANIMAL = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isanimal").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof IAnimals && !(entity instanceof IMob);
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISITEM = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isitem").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityItem;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISPLAYER = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isplayer").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityPlayer;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ITEMSTACK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("item").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional<Entity> a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            return ValueObjectTypeItemStack.ValueItemStack.of(a.isPresent() && a.get() instanceof EntityItem ? ((EntityItem)a.get()).func_92059_d() : ItemStack.field_190927_a);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HEALTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("health").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityLivingBase ? (double)((EntityLivingBase)entity).func_110143_aJ() : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_WIDTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("width").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity != null ? (double)entity.field_70130_N : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_HEIGHT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("height").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity != null ? (double)entity.field_70131_O : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISBURNING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isburning").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70027_ad();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISWET = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("iswet").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70026_G();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISSNEAKING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("issneaking").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70093_af();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISEATING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("iseating").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184605_cv() > 0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ARMORINVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("armorinventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional<Entity> a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            if (a.isPresent()) {
                Entity entity = (Entity)a.get();
                return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityArmorInventory(entity.field_70170_p, entity));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, Collections.emptyList());
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_INVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional<Entity> a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            if (a.isPresent()) {
                Entity entity = (Entity)a.get();
                return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityInventory(entity.field_70170_p, entity));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, Collections.emptyList());
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_MODNAME = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String modName = "";
            if (a.getRawValue().isPresent()) {
                try {
                    Entity entity = (Entity)a.getRawValue().get();
                    EntityRegistry.EntityRegistration entityRegistration = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true);
                    modName = entityRegistration.getContainer().getName();
                }
                catch (NullPointerException e) {
                    modName = "Minecraft";
                }
            }
            return ValueTypeString.ValueString.of(modName);
        }
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETBLOCK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("targetblock").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            IBlockState blockState = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)a.getRawValue().get();
                double reachDistance = 5.0;
                double eyeHeight = entity.func_70047_e();
                if (entity instanceof EntityPlayerMP) {
                    reachDistance = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
                }
                Vec3d lookVec = entity.func_70040_Z();
                Vec3d origin = new Vec3d(entity.field_70165_t, entity.field_70163_u + eyeHeight, entity.field_70161_v);
                Vec3d direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
                RayTraceResult mop = entity.field_70170_p.func_72901_a(origin, direction, true);
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    blockState = entity.field_70170_p.func_180495_p(mop.func_178782_a());
                }
            }
            return ValueObjectTypeBlock.ValueBlock.of(blockState);
        }
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETENTITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ENTITY).symbolOperator("targetentity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            Entity entityOut = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)a.getRawValue().get();
                double reachDistance = 5.0;
                double eyeHeight = entity.func_70047_e();
                if (entity instanceof EntityPlayerMP) {
                    reachDistance = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
                }
                Vec3d lookVec = entity.func_70040_Z();
                Vec3d origin = new Vec3d(entity.field_70165_t, entity.field_70163_u + eyeHeight, entity.field_70161_v);
                Vec3d direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
                float size = entity.func_70111_Y();
                List list = entity.field_70170_p.func_72839_b((Entity)entity, entity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance).func_72314_b((double)size, (double)size, (double)size));
                for (Entity e : list) {
                    double distance;
                    if (!e.func_70067_L()) continue;
                    float f10 = e.func_70111_Y();
                    AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_72314_b((double)f10, (double)f10, (double)f10);
                    RayTraceResult mop = axisalignedbb.func_72327_a(origin, direction);
                    if (axisalignedbb.func_72318_a(origin)) {
                        entityOut = e;
                        continue;
                    }
                    if (mop == null || !((distance = origin.func_72438_d(mop.field_72307_f)) < reachDistance) && reachDistance != 0.0) continue;
                    if (e == entity.func_184187_bx() && !entity.canRiderInteract()) {
                        if (reachDistance != 0.0) continue;
                        entityOut = e;
                        continue;
                    }
                    entityOut = e;
                    reachDistance = distance;
                }
            }
            return ValueObjectTypeEntity.ValueEntity.of(entityOut);
        }
    }).build());
    public static final IOperator OBJECT_PLAYER_HASGUIOPEN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("hasguiopen").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityPlayer) {
                EntityPlayer entity = (EntityPlayer)a.getRawValue().get();
                return ValueTypeBoolean.ValueBoolean.of(entity.field_71070_bA != entity.field_71069_bz);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_MAIN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("helditem1").operatorName("helditem").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ItemStack itemStack = ItemStack.field_190927_a;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                itemStack = ((EntityLivingBase)a.getRawValue().get()).func_184614_ca();
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_OFF = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("helditem2").operatorName("helditemoffhand").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ItemStack itemStack = ItemStack.field_190927_a;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                itemStack = ((EntityLivingBase)a.getRawValue().get()).func_184592_cb();
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_MOUNTED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("mounted").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ArrayList passengers = Lists.newArrayList();
            if (a.getRawValue().isPresent()) {
                for (Entity passenger : ((Entity)a.getRawValue().get()).func_184188_bt()) {
                    passengers.add(ValueObjectTypeEntity.ValueEntity.of(passenger));
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, passengers);
        }
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_CONTENTS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemframecontents").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ItemStack itemStack = ItemStack.field_190927_a;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityItemFrame) {
                itemStack = ((EntityItemFrame)a.getRawValue().get()).func_82335_i();
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_ROTATION = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("itemframerotation").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            Integer rotation = 0;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityItemFrame) {
                rotation = ((EntityItemFrame)a.getRawValue().get()).func_82333_j();
            }
            return ValueTypeInteger.ValueInteger.of(rotation);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HURTSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("hurtsound").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            String sound;
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String hurtSound = "";
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase && (sound = ObfuscationHelpers.getEntityLivingBaseHurtSound((EntityLivingBase)a.getRawValue().get()).func_187503_a().toString()) != null) {
                hurtSound = sound;
            }
            return ValueTypeString.ValueString.of(hurtSound);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_DEATHSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("deathsound").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            String sound;
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String hurtSound = "";
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase && (sound = ObfuscationHelpers.getEntityLivingBaseDeathSound((EntityLivingBase)a.getRawValue().get()).func_187503_a().toString()) != null) {
                hurtSound = sound;
            }
            return ValueTypeString.ValueString.of(hurtSound);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_AGE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("age").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            int age = 0;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                age = ((EntityLivingBase)a.getRawValue().get()).func_70654_ax();
            }
            return ValueTypeInteger.ValueInteger.of(age);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_ISCHILD = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("ischild").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            boolean child = false;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                child = ((EntityLivingBase)a.getRawValue().get()).func_70631_g_();
            }
            return ValueTypeBoolean.ValueBoolean.of(child);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("canbreed").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            boolean canBreed = false;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityAgeable) {
                canBreed = ((EntityAgeable)a.getRawValue().get()).func_70874_b() == 0;
            }
            return ValueTypeBoolean.ValueBoolean.of(canBreed);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_ISINLOVE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isinlove").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            boolean inLove = false;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityAnimal) {
                inLove = ((EntityAnimal)a.getRawValue().get()).func_70880_s();
            }
            return ValueTypeBoolean.ValueBoolean.of(inLove);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREEDWITH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.inputTypes(ValueTypes.OBJECT_ENTITY, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.BOOLEAN).symbolOperator("canbreedwith").renderPattern(IConfigRenderPattern.INFIX).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ValueObjectTypeItemStack.ValueItemStack b = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1);
            boolean canBreedWith = false;
            if (a.getRawValue().isPresent() && !b.getRawValue().func_190926_b() && a.getRawValue().get() instanceof EntityAnimal) {
                canBreedWith = ((EntityAnimal)a.getRawValue().get()).func_70877_b(b.getRawValue());
            }
            return ValueTypeBoolean.ValueBoolean.of(canBreedWith);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_ISSHEARABLE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isshearable").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && a.getRawValue().get() instanceof IShearable && ((IShearable)a.getRawValue().get()).isShearable(null, null, null));
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_AMOUNT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("amount").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.amount : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_BLOCK = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            return ValueObjectTypeBlock.ValueBlock.of(a.isPresent() ? ((FluidStack)a.get()).getFluid().getBlock().func_176223_P() : null);
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_LUMINOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("luminosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getLuminosity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_DENSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("density").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getDensity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_VISCOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("viscosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getViscosity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISGASEOUS = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isgaseous").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<FluidStack, Boolean>(){

        @Override
        public Boolean getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null && fluidStack.getFluid().isGaseous(fluidStack);
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_RARITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            return ValueTypeString.ValueString.of(a.isPresent() ? ((FluidStack)a.get()).getFluid().getRarity((FluidStack)((FluidStack)a.get())).field_77934_f : "");
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwfluidequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            Optional b = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (a.isPresent() && b.isPresent()) {
                equal = ((FluidStack)a.get()).isFluidEqual((FluidStack)b.get());
            } else if (!a.isPresent() && !b.isPresent()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_MODNAME = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeFluidStack.ValueFluidStack a = (ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0);
            String modName = "";
            if (a.getRawValue().isPresent()) {
                try {
                    Fluid fluid = ((FluidStack)a.getRawValue().get()).getFluid();
                    String modDomain = null;
                    if (fluid.getStill() != null) {
                        modDomain = fluid.getStill().func_110624_b();
                    } else if (fluid.getFlowing() != null) {
                        modDomain = fluid.getFlowing().func_110624_b();
                    } else if (fluid.getBlock() != null) {
                        modDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)fluid.getBlock())).func_110624_b();
                    }
                    String modId = org.cyclops.cyclopscore.helper.Helpers.getModId((String)modDomain);
                    modName = ((ModContainer)Loader.instance().getIndexedModList().get(modId)).getName();
                }
                catch (NullPointerException e) {
                    modName = "Minecraft";
                }
            }
            return ValueTypeString.ValueString.of(modName);
        }
    }).build());
    public static final IOperator OPERATOR_APPLY = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.conditionalOutputTypeDeriver(OperatorBuilders.newOperatorConditionalOutputDeriver(1)).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.LIST)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

        @Override
        public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IVariable variable = variables.getVariables()[0];
            return ValueHelpers.evaluateOperator(innerOperator, variable);
        }
    })).build());
    public static final IOperator OPERATOR_APPLY_2;
    public static final IOperator OPERATOR_APPLY_3;
    public static final IOperator OPERATOR_MAP;
    public static final IOperator OPERATOR_FILTER;
    public static final IOperator OPERATOR_CONJUNCTION;
    public static final IOperator OPERATOR_DISJUNCTION;
    public static final IOperator OPERATOR_NEGATION;
    public static final IOperator OPERATOR_PIPE;
    public static final IOperator OPERATOR_FLIP;
    public static final IOperator OPERATOR_REDUCE;
    public static final GeneralOperator GENERAL_CHOICE;
    public static final GeneralOperator GENERAL_IDENTITY;

    private static IOperatorRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IOperatorRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IOperatorRegistry.class);
        }
        return OperatorRegistry.getInstance();
    }

    public static void load() {
    }

    static {
        REGISTRY.registerSerializer(new CurriedOperator.Serializer());
        OPERATOR_APPLY_2 = REGISTRY.register(OperatorBuilders.OPERATOR.renderPattern(IConfigRenderPattern.INFIX_2).conditionalOutputTypeDeriver(OperatorBuilders.newOperatorConditionalOutputDeriver(2)).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply2").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.LIST, ValueTypes.LIST)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                IVariable variable0 = variables.getVariables()[0];
                IVariable variable1 = variables.getVariables()[1];
                return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1);
            }
        })).build());
        OPERATOR_APPLY_3 = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.renderPattern(IConfigRenderPattern.INFIX_3).conditionalOutputTypeDeriver(OperatorBuilders.newOperatorConditionalOutputDeriver(3)).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperator("apply3").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.LIST, ValueTypes.LIST, ValueTypes.LIST)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                IVariable variable0 = variables.getVariables()[0];
                IVariable variable1 = variables.getVariables()[1];
                IVariable variable2 = variables.getVariables()[2];
                return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1, variable2);
            }
        })).build());
        OPERATOR_MAP = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperator("map").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                ValueTypeList.ValueList inputList = (ValueTypeList.ValueList)variables.getValue(0);
                return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyOperatorMapped(innerOperator, inputList.getRawValue()));
            }
        })).build());
        OPERATOR_FILTER = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperator("filter").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                ValueTypeList.ValueList inputList = (ValueTypeList.ValueList)variables.getValue(0);
                ArrayList filtered = Lists.newArrayList();
                for (IValue value : inputList.getRawValue()) {
                    IValue result = ValueHelpers.evaluateOperator(innerOperator, value);
                    if (result.getType() != ValueTypes.BOOLEAN) {
                        L10NHelpers.UnlocalizedString error = new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_predicate", new Object[]{OPERATOR_FILTER.getLocalizedNameFull(), result.getType(), ValueTypes.BOOLEAN});
                        throw new EvaluationException(error.localize());
                    }
                    if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                    filtered.add(value);
                }
                Object valueType = inputList.getRawValue().getValueType();
                return ValueTypeList.ValueList.ofList(valueType, filtered);
            }
        })).build());
        OPERATOR_CONJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".&&.").operatorName("conjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(new IOperatorValuePropagator<Pair<IOperator, IOperator>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, IOperator> input) throws EvaluationException {
                return ValueTypeOperator.ValueOperator.of(CombinedOperator.Conjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight()));
            }
        })).build());
        REGISTRY.registerSerializer(new CombinedOperator.Conjunction.Serializer());
        OPERATOR_DISJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".||.").operatorName("disjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(new IOperatorValuePropagator<Pair<IOperator, IOperator>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, IOperator> input) throws EvaluationException {
                return ValueTypeOperator.ValueOperator.of(CombinedOperator.Disjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight()));
            }
        })).build());
        REGISTRY.registerSerializer(new CombinedOperator.Disjunction.Serializer());
        OPERATOR_NEGATION = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol("!.").operatorName("negation").function(OperatorBuilders.FUNCTION_ONE_PREDICATE.build(new IOperatorValuePropagator<IOperator, IValue>(){

            @Override
            public IValue getOutput(IOperator input) throws EvaluationException {
                return ValueTypeOperator.ValueOperator.of(CombinedOperator.Negation.asOperator(input));
            }
        })).build());
        REGISTRY.registerSerializer(new CombinedOperator.Negation.Serializer());
        OPERATOR_PIPE = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".").operatorName("pipe").function(OperatorBuilders.FUNCTION_TWO_OPERATORS.build(new IOperatorValuePropagator<Pair<IOperator, IOperator>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, IOperator> input) throws EvaluationException {
                return ValueTypeOperator.ValueOperator.of(CombinedOperator.Pipe.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight()));
            }
        })).build());
        REGISTRY.registerSerializer(new CombinedOperator.Pipe.Serializer());
        OPERATOR_FLIP = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbolOperator("flip").function(OperatorBuilders.FUNCTION_ONE_OPERATOR.build(new IOperatorValuePropagator<IOperator, IValue>(){

            @Override
            public IValue getOutput(IOperator input) throws EvaluationException {
                return ValueTypeOperator.ValueOperator.of(CombinedOperator.Flip.asOperator(input));
            }
        })).build());
        REGISTRY.registerSerializer(new CombinedOperator.Flip.Serializer());
        OPERATOR_REDUCE = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_3_LONG).output(ValueTypes.CATEGORY_ANY).symbolOperator("reduce").conditionalOutputTypeDeriver(new OperatorBuilder.IConditionalOutputTypeDeriver(){

            @Override
            public IValueType getConditionalOutputType(OperatorBase operator, IVariable[] input) {
                return input[2].getType();
            }
        }).function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                Object accumulator = variables.getValue(2);
                IOperator innerOperator = OperatorBuilders.getSafeOperator((ValueTypeOperator.ValueOperator)variables.getValue(0), accumulator.getType());
                ValueTypeList.ValueList inputList = (ValueTypeList.ValueList)variables.getValue(1);
                for (IValue listValue : inputList.getRawValue()) {
                    accumulator = innerOperator.evaluate(new Variable(accumulator.getType(), accumulator), new Variable<IValue>(listValue.getType(), listValue));
                }
                return accumulator;
            }
        }).build());
        GENERAL_CHOICE = REGISTRY.register(new GeneralChoiceOperator("?", "choice"));
        GENERAL_IDENTITY = REGISTRY.register(new GeneralIdentityOperator("id", "identity"));
    }
}

