/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeEntity
extends ValueObjectTypeBase<ValueEntity>
implements IValueTypeNamed<ValueEntity>,
IValueTypeNullable<ValueEntity> {
    public ValueObjectTypeEntity() {
        super("entity");
    }

    @Override
    public ValueEntity getDefault() {
        return ValueEntity.of((UUID)null);
    }

    @Override
    public String toCompactString(ValueEntity value) {
        Optional<Entity> entity = value.getRawValue();
        if (entity.isPresent()) {
            Entity e = (Entity)entity.get();
            if (e instanceof EntityItem) {
                return ((EntityItem)e).func_92059_d().func_82833_r();
            }
            return e.func_70005_c_();
        }
        return "";
    }

    @Override
    public String serialize(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            return ((UUID)uuid.get()).toString();
        }
        return "";
    }

    @Override
    public ValueEntity deserialize(String value) {
        try {
            return ValueEntity.of(UUID.fromString(value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ValueEntity.of((UUID)null);
        }
    }

    @Override
    public String getName(ValueEntity a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueEntity a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return null;
    }

    public static class ValueEntity
    extends ValueBase {
        private final Optional<UUID> value;

        protected ValueEntity(@Nullable Entity value) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = value == null ? Optional.absent() : Optional.of((Object)value.func_110124_au());
        }

        private ValueEntity(@Nullable UUID entityUuid) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = Optional.fromNullable((Object)entityUuid);
        }

        public Optional<Entity> getRawValue() {
            Optional<UUID> uuid = this.getUuid();
            if (uuid.isPresent()) {
                if (MinecraftHelpers.isClientSide()) {
                    for (Entity entity : FMLClientHandler.instance().getWorldClient().func_72910_y()) {
                        if (!entity.func_110124_au().equals(uuid.get())) continue;
                        return Optional.of((Object)entity);
                    }
                    return Optional.absent();
                }
                return Optional.fromNullable((Object)FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a((UUID)uuid.get()));
            }
            return Optional.absent();
        }

        public Optional<UUID> getUuid() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueEntity) {
                if (((ValueEntity)o).value.isPresent() && this.value.isPresent()) {
                    return ((UUID)((ValueEntity)o).value.get()).equals(this.value.get());
                }
                if (!((ValueEntity)o).value.isPresent() && !this.value.isPresent()) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.getRawValue().isPresent() ? ((Entity)this.getRawValue().get()).hashCode() : 0);
        }

        public static ValueEntity of(@Nullable Entity entity) {
            return new ValueEntity(entity);
        }

        public static ValueEntity of(@Nullable UUID entityUuid) {
            return new ValueEntity(entityUuid);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeEntity.ValueEntity(value=" + this.value + ")";
        }
    }
}

