/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeItemStack
extends ValueObjectTypeBase<ValueItemStack>
implements IValueTypeNamed<ValueItemStack>,
IValueTypeNullable<ValueItemStack> {
    public ValueObjectTypeItemStack() {
        super("itemstack");
    }

    @Override
    public ValueItemStack getDefault() {
        return ValueItemStack.of(ItemStack.field_190927_a);
    }

    @Override
    public String toCompactString(ValueItemStack value) {
        ItemStack itemStack = value.getRawValue();
        return !itemStack.func_190926_b() ? itemStack.func_82833_r() : "";
    }

    @Override
    public String serialize(ValueItemStack value) {
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack itemStack = value.getRawValue();
        if (!itemStack.func_190926_b()) {
            itemStack.func_77955_b(tag);
            tag.func_74768_a("Count", itemStack.func_190916_E());
        }
        return tag.toString();
    }

    @Override
    public ValueItemStack deserialize(String value) {
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            ItemStack itemStack = new ItemStack(tag);
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(tag.func_74762_e("Count"));
            }
            return ValueItemStack.of(itemStack);
        }
        catch (NBTException e) {
            return ValueItemStack.of(ItemStack.field_190927_a);
        }
    }

    @Override
    public String getName(ValueItemStack a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueItemStack a) {
        return !a.getRawValue().func_190926_b();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueItemStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueItemStack>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public L10NHelpers.UnlocalizedString validate(ItemStack itemStack) {
                return null;
            }

            @Override
            public ValueItemStack getValue(ItemStack itemStack) {
                return ValueItemStack.of(itemStack);
            }
        });
    }

    @Override
    public ValueItemStack materialize(ValueItemStack value) throws EvaluationException {
        return ValueItemStack.of(value.getRawValue().func_77946_l());
    }

    public static class ValueItemStack
    extends ValueBase {
        private final ItemStack itemStack;

        private ValueItemStack(ItemStack itemStack) {
            super(ValueTypes.OBJECT_ITEMSTACK);
            this.itemStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueItemStack for a null ItemStack.");
        }

        public static ValueItemStack of(ItemStack itemStack) {
            return new ValueItemStack(itemStack);
        }

        public ItemStack getRawValue() {
            return this.itemStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueItemStack && ItemStackHelpers.areItemStacksIdentical((ItemStack)((ValueItemStack)o).itemStack, (ItemStack)this.itemStack);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeItemStack.ValueItemStack(itemStack=" + this.itemStack + ")";
        }
    }
}

