/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;

public class ValueTypeListProxyNBTFactory<T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V> & INBTProvider>
implements IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> {
    private final String name;
    private final Class<P> proxyClass;

    public ValueTypeListProxyNBTFactory(String name, Class<P> proxyClass) {
        this.name = name;
        this.proxyClass = proxyClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Class<P> getProxyClass() {
        return this.proxyClass;
    }

    @Override
    public String serialize(P values) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        NBTTagCompound tag = new NBTTagCompound();
        ((INBTProvider)values).writeGeneratedFieldsToNBT(tag);
        return tag.toString();
    }

    @Override
    public P deserialize(String value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        try {
            Constructor<P> constructor = this.getProxyClass().getConstructor(new Class[0]);
            IValueTypeListProxy proxy = (IValueTypeListProxy)constructor.newInstance(new Object[0]);
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            ((INBTProvider)proxy).readGeneratedFieldsFromNBT(tag);
            return (P)proxy;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | NBTException e) {
            e.printStackTrace();
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(e.getMessage());
        }
    }
}

