/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeStringRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;

public class GuiElementValueTypeString<G extends Gui, C extends Container>
implements IGuiInputElement<RenderPattern, G, C>,
IDropdownEntryListener {
    private final IValueType valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private String defaultInputString;
    private String inputString;
    private Set<IDropdownEntry<?>> dropdownPossibilities = Collections.emptySet();
    private IDropdownEntryListener dropdownEntryListener = null;

    public GuiElementValueTypeString(IValueType valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
        this.defaultInputString = this.getValueType().toCompactString(this.getValueType().getDefault());
    }

    public void setInputString(String inputString, GuiElementValueTypeStringRenderPattern subGui) {
        this.inputString = inputString;
        if (subGui != null) {
            subGui.getSearchField().func_146180_a(inputString);
        }
    }

    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)this.getValueType().getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public void loadTooltip(List<String> lines) {
        this.getValueType().loadTooltip(lines, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputString = new String(this.defaultInputString);
    }

    @Override
    public void deactivate() {
        this.inputString = null;
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        L10NHelpers.UnlocalizedString error = this.getValueType().canDeserialize(this.inputString);
        if (error == null && !this.validator.apply(this.getValueType().deserialize(this.inputString))) {
            error = new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.value", new Object[0]);
        }
        return error;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getValueType().getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public void onSetDropdownPossiblity(IDropdownEntry<?> dropdownEntry) {
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(dropdownEntry);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiElementValueTypeStringRenderPattern<GuiElementValueTypeStringRenderPattern, G, C> createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        return new GuiElementValueTypeStringRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public IValueType getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public String getDefaultInputString() {
        return this.defaultInputString;
    }

    public String getInputString() {
        return this.inputString;
    }

    public Set<IDropdownEntry<?>> getDropdownPossibilities() {
        return this.dropdownPossibilities;
    }

    public IDropdownEntryListener getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setDefaultInputString(String defaultInputString) {
        this.defaultInputString = defaultInputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setDropdownPossibilities(Set<IDropdownEntry<?>> dropdownPossibilities) {
        this.dropdownPossibilities = dropdownPossibilities;
    }

    public void setDropdownEntryListener(IDropdownEntryListener dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeString)) {
            return false;
        }
        GuiElementValueTypeString other = (GuiElementValueTypeString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$valueType = this.getValueType();
        IValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        if (this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern)) {
            return false;
        }
        String this$defaultInputString = this.getDefaultInputString();
        String other$defaultInputString = other.getDefaultInputString();
        if (this$defaultInputString == null ? other$defaultInputString != null : !this$defaultInputString.equals(other$defaultInputString)) {
            return false;
        }
        String this$inputString = this.getInputString();
        String other$inputString = other.getInputString();
        if (this$inputString == null ? other$inputString != null : !this$inputString.equals(other$inputString)) {
            return false;
        }
        Set<IDropdownEntry<?>> this$dropdownPossibilities = this.getDropdownPossibilities();
        Set<IDropdownEntry<?>> other$dropdownPossibilities = other.getDropdownPossibilities();
        if (this$dropdownPossibilities == null ? other$dropdownPossibilities != null : !((Object)this$dropdownPossibilities).equals(other$dropdownPossibilities)) {
            return false;
        }
        IDropdownEntryListener this$dropdownEntryListener = this.getDropdownEntryListener();
        IDropdownEntryListener other$dropdownEntryListener = other.getDropdownEntryListener();
        return !(this$dropdownEntryListener == null ? other$dropdownEntryListener != null : !this$dropdownEntryListener.equals(other$dropdownEntryListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 43 : $renderPattern.hashCode());
        String $defaultInputString = this.getDefaultInputString();
        result = result * 59 + ($defaultInputString == null ? 43 : $defaultInputString.hashCode());
        String $inputString = this.getInputString();
        result = result * 59 + ($inputString == null ? 43 : $inputString.hashCode());
        Set<IDropdownEntry<?>> $dropdownPossibilities = this.getDropdownPossibilities();
        result = result * 59 + ($dropdownPossibilities == null ? 43 : ((Object)$dropdownPossibilities).hashCode());
        IDropdownEntryListener $dropdownEntryListener = this.getDropdownEntryListener();
        result = result * 59 + ($dropdownEntryListener == null ? 43 : $dropdownEntryListener.hashCode());
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeString(valueType=" + this.getValueType() + ", validator=" + this.getValidator() + ", renderPattern=" + this.getRenderPattern() + ", defaultInputString=" + this.getDefaultInputString() + ", inputString=" + this.getInputString() + ", dropdownPossibilities=" + this.getDropdownPossibilities() + ", dropdownEntryListener=" + this.getDropdownEntryListener() + ")";
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class SubGuiValueTypeInfo<S extends ISubGuiBox, G extends GuiContainerExtended, C extends Container>
    extends SubGuiBox.Base {
        private final IGuiInputElement element;
        protected final G gui;
        protected final C container;

        public SubGuiValueTypeInfo(G gui, C container, IGuiInputElement<S, G, C> element, int x, int y, int width, int height) {
            super(SubGuiBox.Box.DARK, x, y, width, height);
            this.gui = gui;
            this.container = container;
            this.element = element;
        }

        protected abstract boolean showError();

        protected abstract L10NHelpers.UnlocalizedString getLastError();

        protected abstract ResourceLocation getTexture();

        protected int getSignalX() {
            return this.getWidth() - 22;
        }

        protected int getSignalY() {
            return (this.getHeight() - 12) / 2;
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            fontRenderer.func_78276_b(this.element.getLocalizedNameFull(), x + 2, y + 6, Helpers.RGBToInt((int)240, (int)240, (int)240));
            if (this.showError()) {
                L10NHelpers.UnlocalizedString lastError = this.getLastError();
                if (lastError != null) {
                    Images.ERROR.draw((Gui)this, x + this.getSignalX(), y + this.getSignalY() - 1);
                } else {
                    Images.OK.draw((Gui)this, x + this.getSignalX(), y + this.getSignalY() + 1);
                }
            }
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            L10NHelpers.UnlocalizedString lastError;
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            int x = this.getX();
            int y = this.getY();
            if (this.showError() && (lastError = this.getLastError()) != null && this.gui.func_146978_c(x + this.getSignalX(), y + this.getSignalY() - 1, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), mouseX, mouseY)) {
                LinkedList lines = Lists.newLinkedList();
                lines.addAll(StringHelpers.splitLines((String)lastError.localize(), (int)25, (String)TextFormatting.RED.toString()));
                this.gui.drawTooltip((List)lines, mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

