/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class ValueTypeVariableFacade<V extends IValue>
extends VariableFacadeBase
implements IValueTypeVariableFacade<V> {
    private final IValueType<V> valueType;
    private final V value;
    private IVariable<V> variable = null;

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, V value) {
        super(generateId);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, V value) {
        super(id);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, String value) {
        super(generateId);
        this.valueType = valueType;
        this.value = valueType.deserialize(value);
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, String value) {
        super(id);
        this.valueType = valueType;
        this.value = valueType.deserialize(value);
    }

    @Override
    public IVariable<V> getVariable(IPartNetwork network) {
        if (this.isValid()) {
            if (this.variable == null) {
                this.variable = new Variable<V>(this.getValueType(), this.getValue());
            }
            return this.variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getValueType() != null && this.getValue() != null;
    }

    @Override
    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError(new L10NHelpers.UnlocalizedString("variable.integrateddynamics.error.invalid_item", new Object[0]));
        } else if (!ValueHelpers.correspondsTo(this.getValueType(), containingValueType)) {
            validator.addError(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{new L10NHelpers.UnlocalizedString(containingValueType.getUnlocalizedName(), new Object[0]), new L10NHelpers.UnlocalizedString(this.getValueType().getUnlocalizedName(), new Object[0])}));
        }
    }

    @Override
    public IValueType getOutputType() {
        return this.getValueType();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, EntityPlayer entityPlayer) {
        if (this.isValid()) {
            V value = this.getValue();
            this.getValueType().loadTooltip(list, false, value);
            list.add(L10NHelpers.localize((String)"valuetype.integrateddynamics.tooltip.value", (Object[])new Object[]{this.getValueType().toCompactString(value)}));
        }
        super.addInformation(list, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads) {
        IBakedModel bakedModel;
        if (this.isValid() && (bakedModel = variableModelBaked.getSubModels(VariableModelProviders.VALUETYPE).getBakedModels().get(this.getValueType())) != null) {
            quads.addAll(bakedModel.func_188616_a(null, null, 0L));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueTypeVariableFacade)) {
            return false;
        }
        ValueTypeVariableFacade other = (ValueTypeVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IValueType<V> this$valueType = this.getValueType();
        IValueType<V> other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        IVariable<V> this$variable = this.getVariable();
        IVariable<V> other$variable = other.getVariable();
        return !(this$variable == null ? other$variable != null : !this$variable.equals(other$variable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueTypeVariableFacade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        IValueType<V> $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        IVariable<V> $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        return result;
    }

    @Override
    public IValueType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public IVariable<V> getVariable() {
        return this.variable;
    }

    public void setVariable(IVariable<V> variable) {
        this.variable = variable;
    }

    public String toString() {
        return "ValueTypeVariableFacade(valueType=" + this.getValueType() + ", value=" + this.getValue() + ", variable=" + this.getVariable() + ")";
    }
}

