/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class ValueTypeItemStackLPElement<V extends IValue>
extends ValueTypeLPElementBase {
    private final IItemStackToValue<V> itemStackToValue;
    private ItemStack itemStack = ItemStack.field_190927_a;

    public ValueTypeItemStackLPElement(IValueType valueType, IItemStackToValue<V> itemStackToValue) {
        super(valueType);
        this.itemStackToValue = itemStackToValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.SINGLE_SLOT;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public boolean canWriteElementPre() {
        return this.itemStackToValue.isNullable() || !this.itemStack.func_190926_b();
    }

    @Override
    public void activate() {
        this.itemStack = ItemStack.field_190927_a;
    }

    @Override
    public void deactivate() {
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (!this.itemStackToValue.isNullable() && this.itemStack.func_190926_b()) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input_item", new Object[0]);
        }
        return this.itemStackToValue.validate(this.itemStack);
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    public IValue getValue() {
        return this.itemStackToValue.getValue(this.itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        return new SubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        ((ContainerLogicProgrammerBase)((SubGuiRenderPattern)subGui).container).getTemporaryInputSlots().func_70299_a(0, this.itemStack);
    }

    public static interface IItemStackToValue<V extends IValue> {
        public boolean isNullable();

        public L10NHelpers.UnlocalizedString validate(ItemStack var1);

        public V getValue(ItemStack var1);
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SubGuiRenderPattern
    extends RenderPattern<ValueTypeItemStackLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
        public SubGuiRenderPattern(ValueTypeItemStackLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            IValueType valueType = ((ValueTypeItemStackLPElement)this.element).getValueType();
            if (!((ContainerLogicProgrammerBase)this.container).hasWriteItemInSlot() && ((GuiLogicProgrammerBase)this.gui).func_146978_c(232, 110, 18, 18, mouseX, mouseY)) {
                ((GuiLogicProgrammerBase)this.gui).drawTooltip(this.getValueTypeTooltip(valueType), mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

