/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.AttachCapabilitiesEventNetwork;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.IFullNetworkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.network.event.INetworkEventBus;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementRemoveEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkEventBus;
import org.cyclops.integrateddynamics.core.path.Cluster;
import org.cyclops.integrateddynamics.core.path.PathFinder;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class Network
implements INetwork {
    private Cluster baseCluster;
    private final INetworkEventBus eventBus = new NetworkEventBus();
    private final TreeSet<INetworkElement> elements = Sets.newTreeSet();
    private TreeSet<INetworkElement> updateableElements = null;
    private TreeMap<INetworkElement, Integer> updateableElementsTicks = null;
    private TreeSet<INetworkElement> invalidatedElements = Sets.newTreeSet();
    private Map<INetworkElement, Long> lastSecondDurations = Maps.newHashMap();
    private final CapabilityDispatcher capabilityDispatcher;
    private IFullNetworkListener[] fullNetworkListeners;
    private volatile boolean changed = false;
    private volatile boolean killed = false;
    private boolean crashed = false;

    public static Network initiateNetworkSetup(IPathElement pathElement) {
        Network network = new Network(PathFinder.getConnectedCluster(pathElement));
        NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).addNewNetwork(network);
        return network;
    }

    public static boolean areNetworksEqual(Network networkA, Network networkB) {
        return networkA.elements.containsAll(networkB.elements) && networkA.elements.size() == networkB.elements.size();
    }

    public Network() {
        this.baseCluster = new Cluster();
        this.capabilityDispatcher = this.gatherCapabilities();
        this.onConstruct();
    }

    public Network(Cluster pathElements) {
        this.baseCluster = pathElements;
        this.capabilityDispatcher = this.gatherCapabilities();
        this.onConstruct();
        this.deriveNetworkElements(this.baseCluster);
    }

    protected CapabilityDispatcher gatherCapabilities() {
        AttachCapabilitiesEventNetwork event = new AttachCapabilitiesEventNetwork(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        List<IFullNetworkListener> listeners = event.getFullNetworkListeners();
        this.fullNetworkListeners = listeners.toArray(new IFullNetworkListener[listeners.size()]);
        return event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities()) : null;
    }

    protected IFullNetworkListener[] gatherFullNetworkListeners() {
        ArrayList listeners = Lists.newArrayList();
        return listeners.toArray(new IFullNetworkListener[listeners.size()]);
    }

    protected void onConstruct() {
    }

    private void deriveNetworkElements(Cluster pathElements) {
        if (!this.killIfEmpty()) {
            for (IPathElement pathElement : pathElements) {
                INetworkElementProvider networkElementProvider;
                BlockPos pos;
                World world = pathElement.getPosition().getWorld();
                INetworkCarrier networkCarrier = (INetworkCarrier)TileHelpers.getCapability((World)world, (BlockPos)(pos = pathElement.getPosition().getBlockPos()), null, NetworkCarrierConfig.CAPABILITY);
                if (networkCarrier != null) {
                    INetwork network = networkCarrier.getNetwork();
                    if (network != null) {
                        network.removePathElement(pathElement);
                    }
                    networkCarrier.setNetwork(null);
                    networkCarrier.setNetwork(this);
                }
                if ((networkElementProvider = (INetworkElementProvider)TileHelpers.getCapability((DimPos)pathElement.getPosition(), null, NetworkElementProviderConfig.CAPABILITY)) == null) continue;
                for (INetworkElement element : networkElementProvider.createNetworkElements(world, pos)) {
                    this.addNetworkElement(element, true);
                }
            }
            this.onNetworkChanged();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.updateableElements != null;
    }

    @Override
    public INetworkEventBus getEventBus() {
        return this.eventBus;
    }

    public void initialize() {
        this.initialize(false);
    }

    public boolean equals(Object object) {
        return object instanceof Network && Network.areNetworksEqual(this, (Network)object);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("baseCluster", (NBTBase)this.baseCluster.toNBT());
        tag.func_74757_a("crashed", this.crashed);
        if (this.capabilityDispatcher != null) {
            tag.func_74782_a("ForgeCaps", (NBTBase)this.capabilityDispatcher.serializeNBT());
        }
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        this.baseCluster.fromNBT(tag.func_74775_l("baseCluster"));
        this.crashed = tag.func_74767_n("crashed");
        if (this.capabilityDispatcher != null && tag.func_74764_b("ForgeCaps")) {
            this.capabilityDispatcher.deserializeNBT(tag.func_74775_l("ForgeCaps"));
        }
        this.deriveNetworkElements(this.baseCluster);
        this.initialize(true);
    }

    @Override
    public synchronized boolean addNetworkElement(INetworkElement element, boolean networkPreinit) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.addNetworkElement(element, networkPreinit)) continue;
            return false;
        }
        if (this.getEventBus().postCancelable(new NetworkElementAddEvent.Pre(this, element))) {
            IEventListenableNetworkElement listenableElement;
            Object listener;
            this.elements.add(element);
            if (!element.onNetworkAddition(this)) {
                this.elements.remove(element);
                return false;
            }
            if (!networkPreinit) {
                this.addNetworkElementUpdateable(element);
            }
            if (element instanceof IEventListenableNetworkElement && (listener = (listenableElement = (IEventListenableNetworkElement)element).getNetworkEventListener()) != null && listener.hasEventSubscriptions()) {
                for (Class<INetworkEvent> eventType : listener.getSubscribedEvents()) {
                    this.getEventBus().register(listenableElement, eventType);
                }
            }
            this.getEventBus().post(new NetworkElementAddEvent.Post(this, element));
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    @Override
    public void addNetworkElementUpdateable(INetworkElement element) {
        if (element.isUpdate()) {
            this.updateableElements.add(element);
            this.updateableElementsTicks.put(element, 0);
        }
    }

    @Override
    public boolean removeNetworkElementPre(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.removeNetworkElementPre(element)) continue;
            return false;
        }
        return this.getEventBus().postCancelable(new NetworkElementRemoveEvent.Pre(this, element));
    }

    @Override
    public synchronized void setPriority(INetworkElement element, int priority) {
        this.elements.remove(element);
        Integer oldTickValue = null;
        if (element.isUpdate()) {
            this.updateableElements.remove(element);
            oldTickValue = this.updateableElementsTicks.remove(element);
        }
        element.setPriority(this, priority);
        this.elements.add(element);
        if (element.isUpdate()) {
            this.updateableElements.add(element);
            if (oldTickValue != null) {
                this.updateableElementsTicks.put(element, oldTickValue);
            }
        }
    }

    @Override
    public void removeNetworkElementPost(INetworkElement element) {
        IEventListenableNetworkElement listenableElement;
        Object listener;
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.removeNetworkElementPost(element);
        }
        if (element instanceof IEventListenableNetworkElement && (listener = (listenableElement = (IEventListenableNetworkElement)element).getNetworkEventListener()) != null && listener.hasEventSubscriptions()) {
            this.getEventBus().unregister(listenableElement);
        }
        element.beforeNetworkKill(this);
        element.onNetworkRemoval(this);
        this.elements.remove(element);
        this.removeNetworkElementUpdateable(element);
        this.getEventBus().post(new NetworkElementRemoveEvent.Post(this, element));
        this.onNetworkChanged();
    }

    @Override
    public synchronized void removeNetworkElementUpdateable(INetworkElement element) {
        this.updateableElements.remove(element);
        this.updateableElementsTicks.remove(element);
    }

    protected void initialize(boolean silent) {
        this.updateableElements = Sets.newTreeSet();
        this.updateableElementsTicks = Maps.newTreeMap();
        for (INetworkElement element : this.elements) {
            this.addNetworkElementUpdateable(element);
            if (!silent) {
                element.afterNetworkAlive(this);
            }
            element.afterNetworkReAlive(this);
        }
    }

    @Override
    public void kill() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.kill();
        }
        for (INetworkElement element : this.elements) {
            element.beforeNetworkKill(this);
        }
        this.killed = true;
    }

    @Override
    public boolean killIfEmpty() {
        if (this.baseCluster.isEmpty()) {
            this.kill();
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean canUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.canUpdate(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.postUpdate(element);
        }
    }

    @Override
    public void onSkipUpdate(INetworkElement element) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.onSkipUpdate(element);
        }
    }

    @Override
    public final synchronized void update() {
        this.changed = false;
        if (this.killIfEmpty() || this.killed) {
            NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).removeInvalidatedNetwork(this);
        } else {
            this.onUpdate();
            boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
            if (!isBeingDiagnozed && !this.lastSecondDurations.isEmpty()) {
                this.lastSecondDurations.clear();
            }
            for (INetworkElement element : this.updateableElements) {
                try {
                    if (!this.isValid(element)) continue;
                    long startTime = 0L;
                    if (isBeingDiagnozed) {
                        startTime = System.nanoTime();
                    }
                    int lastElementTick = this.updateableElementsTicks.get(element);
                    if (this.canUpdate(element)) {
                        if (lastElementTick <= 0) {
                            this.updateableElementsTicks.put(element, element.getUpdateInterval() - 1);
                            element.update(this);
                            this.postUpdate(element);
                        } else {
                            this.updateableElementsTicks.put(element, lastElementTick - 1);
                        }
                    } else {
                        this.onSkipUpdate(element);
                        this.updateableElementsTicks.put(element, lastElementTick - 1);
                    }
                    if (!isBeingDiagnozed) continue;
                    long duration = System.nanoTime() - startTime;
                    Long lastDuration = this.lastSecondDurations.get(element);
                    if (lastDuration != null) {
                        duration += lastDuration.longValue();
                    }
                    this.lastSecondDurations.put(element, duration);
                }
                catch (PartStateException e) {
                    IntegratedDynamics.clog(Level.WARN, "Attempted to tick a part that was not properly unloaded. Report this to the Integrated Dynamics issue tracker with details on what you did leading up to this stacktrace. The part was forcefully unloaded");
                    e.printStackTrace();
                    element.invalidate(this);
                }
            }
        }
    }

    protected void onUpdate() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.update();
        }
    }

    @Override
    public synchronized boolean removePathElement(IPathElement pathElement) {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            if (fullNetworkListener.removePathElement(pathElement)) continue;
            return false;
        }
        if (this.baseCluster.remove(pathElement)) {
            INetworkElementProvider networkElementProvider = (INetworkElementProvider)TileHelpers.getCapability((DimPos)pathElement.getPosition(), null, NetworkElementProviderConfig.CAPABILITY);
            if (networkElementProvider != null) {
                Collection<INetworkElement> networkElements = networkElementProvider.createNetworkElements(pathElement.getPosition().getWorld(), pathElement.getPosition().getBlockPos());
                for (INetworkElement networkElement : networkElements) {
                    if (this.removeNetworkElementPre(networkElement)) continue;
                    return false;
                }
                for (INetworkElement networkElement : networkElements) {
                    this.removeNetworkElementPost(networkElement);
                }
                this.onNetworkChanged();
                return true;
            }
        } else {
            Thread.dumpStack();
            IntegratedDynamics.clog(Level.WARN, "Tried to remove a path element from a network it was not present in.");
            System.out.println("Cluster: " + this.baseCluster);
            System.out.println("Tried removing element: " + pathElement);
        }
        return false;
    }

    @Override
    public void afterServerLoad() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.afterServerLoad();
        }
        for (INetworkElement element : this.getElements()) {
            this.invalidateElement(element);
        }
    }

    @Override
    public void beforeServerStop() {
        for (IFullNetworkListener fullNetworkListener : this.fullNetworkListeners) {
            fullNetworkListener.beforeServerStop();
        }
    }

    @Override
    public Set<INetworkElement> getElements() {
        return this.elements;
    }

    @Override
    public boolean isKilled() {
        return this.killed;
    }

    protected void onNetworkChanged() {
        this.changed = true;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getCablesCount() {
        return this.baseCluster.size();
    }

    @Override
    public long getLastSecondDuration(INetworkElement networkElement) {
        Long duration = this.lastSecondDurations.get(networkElement);
        return duration == null ? 0L : duration;
    }

    @Override
    public void resetLastSecondDurations() {
        this.lastSecondDurations.clear();
    }

    @Override
    public boolean isCrashed() {
        return this.crashed;
    }

    @Override
    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return this.capabilityDispatcher != null && this.capabilityDispatcher.hasCapability(capability, null);
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        return (T)(this.capabilityDispatcher == null ? null : this.capabilityDispatcher.getCapability(capability, null));
    }

    @Override
    public void invalidateElement(INetworkElement element) {
        this.invalidatedElements.add(element);
    }

    @Override
    public void revalidateElement(INetworkElement element) {
        this.invalidatedElements.remove(element);
    }

    protected boolean isValid(INetworkElement element) {
        if (this.invalidatedElements.contains(element)) {
            if (element.canRevalidate(this)) {
                element.revalidate(this);
                return true;
            }
            return false;
        }
        return true;
    }
}

