/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;

public class ContainerPartReader<P extends IPartTypeReader<P, S> & IGuiContainerProvider, S extends IPartStateReader<P>>
extends ContainerMultipartAspects<P, S, IAspectRead> {
    public static final int ASPECT_BOX_HEIGHT = 36;
    private static final int SLOT_IN_X = 96;
    private static final int SLOT_IN_Y = 27;
    private static final int SLOT_OUT_X = 144;
    private static final int SLOT_OUT_Y = 27;
    private final IInventory outputSlots;
    private final BiMap<Integer, IAspectRead> readValueIds = HashBiMap.create();
    private final BiMap<Integer, IAspectRead> readColorIds = HashBiMap.create();

    public ContainerPartReader(EntityPlayer player, PartTarget partTarget, IPartContainer partContainer, P partType) {
        super(player, partTarget, partContainer, partType, partType.getReadAspects());
        int i;
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotVariable(this.inputSlots, i, 96, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.outputSlots = new SimpleInventory(this.getUnfilteredItemCount(), "temporaryOutputSlots", 1);
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotRemoveOnly(this.outputSlots, i, 144, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i + this.getUnfilteredItemCount());
        }
        this.addPlayerInventory(player.field_71071_by, 9, 131);
        for (IAspectRead aspectRead : this.getUnfilteredItems()) {
            this.readValueIds.put((Object)this.getNextValueId(), (Object)aspectRead);
            this.readColorIds.put((Object)this.getNextValueId(), (Object)aspectRead);
        }
    }

    @Override
    public int getAspectBoxHeight() {
        return 36;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = 96;
        slot.field_75221_f = 27 + this.getAspectBoxHeight() * row;
    }

    protected void disableSlotOutput(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex + this.getUnfilteredItemCount());
        slot.field_75223_e = Integer.MIN_VALUE;
        slot.field_75221_f = Integer.MIN_VALUE;
    }

    protected void enableSlotOutput(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex + this.getUnfilteredItemCount());
        slot.field_75223_e = 144;
        slot.field_75221_f = 27 + this.getAspectBoxHeight() * row;
    }

    @Override
    protected void onScroll() {
        super.onScroll();
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlotOutput(i);
        }
    }

    @Override
    protected void enableElementAt(int row, int elementIndex, IAspectRead element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlotOutput(elementIndex, row);
    }

    @Override
    protected int getSizeInventory() {
        return this.getUnfilteredItemCount() * 2;
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.getWorld().field_72995_K) {
            for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
                ItemStack itemStack = this.inputSlots.func_70304_b(i);
                if (!itemStack.func_190926_b()) {
                    player.func_71019_a(itemStack, false);
                }
                if ((itemStack = this.outputSlots.func_70304_b(i)).func_190926_b()) continue;
                player.func_71019_a(itemStack, false);
            }
        }
    }

    public void onDirty() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            ItemStack itemStack = this.inputSlots.func_70301_a(i);
            if (itemStack.func_190926_b() || !this.outputSlots.func_70301_a(i).func_190926_b()) continue;
            ItemStack outputStack = this.writeAspectInfo(!this.getWorld().field_72995_K, itemStack.func_77946_l(), (IAspect)this.getUnfilteredItems().get(i));
            this.outputSlots.func_70299_a(i, outputStack);
            this.inputSlots.func_70298_a(i, 1);
        }
    }

    public void func_75142_b() {
        block6: {
            super.func_75142_b();
            try {
                if (MinecraftHelpers.isClientSide()) break block6;
                for (IAspectRead aspectRead : this.getUnfilteredItems()) {
                    String readValue = "";
                    int readValueColor = 0;
                    IAspectVariable variable = ((IPartTypeReader)this.getPartType()).getVariable(this.getTarget(), (IPartStateReader)this.getPartState(), aspectRead);
                    if (variable != null) {
                        try {
                            Object value = variable.getValue();
                            readValue = value.getType().toCompactString(value);
                            readValueColor = variable.getType().getDisplayColor();
                        }
                        catch (NullPointerException | EvaluationException e) {
                            readValue = "ERROR";
                            readValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
                        }
                    }
                    this.setReadValue(aspectRead, (Pair<String, Integer>)Pair.of((Object)readValue, (Object)readValueColor));
                }
            }
            catch (PartStateException e) {
                this.getPlayer().func_71053_j();
            }
        }
    }

    public void setReadValue(IAspectRead aspectRead, Pair<String, Integer> readValue) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspectRead);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspectRead);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)valueId, (String)((String)readValue.getLeft()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)colorId, (int)((Integer)readValue.getRight()));
    }

    public Pair<String, Integer> getReadValue(IAspectRead aspect) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspect);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspect);
        try {
            return Pair.of((Object)ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)valueId), (Object)ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)colorId));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, IAspect aspect) {
        ItemStack resultStack = super.writeAspectInfo(generateId, itemStack, aspect);
        INetwork network = NetworkHelpers.getNetwork((IBlockAccess)this.getTarget().getCenter().getPos().getWorld(), this.getTarget().getCenter().getPos().getBlockPos());
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
        PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead> event = new PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead>(network, partNetwork, this.getTarget(), (IPartTypeReader)this.getPartType(), (IPartStateReader)this.getPartState(), this.getPlayer(), (IAspectRead)aspect, resultStack);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getItemStack();
    }
}

