/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockCoalGenerator;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.network.CoalGeneratorNetworkElement;

public class TileCoalGenerator
extends TileCableConnectableInventory
implements IEnergyStorage {
    public static final int MAX_PROGRESS = 13;
    public static final int ENERGY_PER_TICK = 20;
    public static final int SLOT_FUEL = 0;
    @NBTPersist
    private int currentlyBurningMax;
    @NBTPersist
    private int currentlyBurning;

    public TileCoalGenerator() {
        super(1, "fuel", 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new CoalGeneratorNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, (Object)this);
        ArrayList allSlots = Lists.newArrayList((Object[])new Integer[]{0});
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addSlotsToSide(side, allSlots);
        }
    }

    public IEnergyNetwork getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void updateBlockState() {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockCoalGenerator.ON, (Comparable)Boolean.valueOf(this.isBurning())));
    }

    public int getProgress() {
        float current = this.currentlyBurning;
        float max = this.currentlyBurningMax;
        if (max == 0.0f) {
            return -1;
        }
        return Math.round(current / max * 13.0f);
    }

    public boolean isBurning() {
        return this.currentlyBurning < this.currentlyBurningMax;
    }

    public boolean canAddEnergy(int energy) {
        IEnergyNetwork network = this.getEnergyNetwork();
        if (network != null && network.receiveEnergy(energy, true) == energy) {
            return true;
        }
        return this.addEnergyFe(energy, true) == energy;
    }

    protected int addEnergy(int energy) {
        IEnergyNetwork network = this.getEnergyNetwork();
        int toFill = energy;
        if (network != null) {
            toFill -= network.receiveEnergy(toFill, false);
        }
        if (toFill > 0) {
            toFill -= this.addEnergyFe(toFill, false);
        }
        return energy - toFill;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.func_145831_w(), this.func_174877_v(), energy, simulate);
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if ((this.func_70301_a(0) != null || this.isBurning()) && this.canAddEnergy(20)) {
            ItemStack fuel;
            if (this.isBurning()) {
                if (this.currentlyBurning++ >= this.currentlyBurningMax) {
                    this.currentlyBurning = 0;
                    this.currentlyBurningMax = 0;
                    this.sendUpdate();
                }
                int toFill = 20;
                this.addEnergy(toFill);
                this.func_70296_d();
            }
            if (!this.isBurning() && (fuel = this.func_70298_a(0, 1)) != null && TileEntityFurnace.func_145954_b((ItemStack)fuel)) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, fuel.func_77973_b().getContainerItem(fuel));
                }
                this.currentlyBurningMax = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                this.currentlyBurning = 0;
                this.sendUpdate();
                this.updateBlockState();
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }
}

