/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectable;
import org.cyclops.integrateddynamics.network.EnergyBatteryNetworkElement;

public class TileEnergyBattery
extends TileCableConnectable
implements IEnergyStorageCapacity {
    @NBTPersist
    private int energy;
    @NBTPersist(useDefaultValue=false)
    private int capacity = BlockEnergyBatteryConfig.capacity;

    public TileEnergyBattery() {
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new EnergyBatteryNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, this);
    }

    protected boolean isCreative() {
        return ((BlockEnergyBatteryBase)this.getBlock()).isCreative();
    }

    public int getEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void updateBlockState() {
        IBlockState blockState;
        if (!this.isCreative() && (blockState = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() == BlockEnergyBattery.getInstance()) {
            int fill = Math.max(0, (int)Math.floor((float)this.energy * (float)(BlockEnergyBattery.FILL.func_177700_c().size() - 1) / (float)this.getMaxEnergyStored()));
            if ((Integer)blockState.func_177229_b((IProperty)BlockEnergyBattery.FILL) != fill) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), blockState.func_177226_a((IProperty)BlockEnergyBattery.FILL, (Comparable)Integer.valueOf(fill)));
                this.sendUpdate();
            }
        }
    }

    protected void setEnergy(int energy) {
        int lastEnergy;
        if (!this.isCreative() && (lastEnergy = this.energy) != energy) {
            this.energy = energy;
            this.updateBlockState();
            this.func_70296_d();
        }
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (!this.isCreative()) {
            energy = Math.max(0, Math.min(energy, BlockEnergyBatteryConfig.energyPerTick));
            int stored = this.getEnergyStored();
            int newEnergy = Math.min(stored + energy, this.getMaxEnergyStored());
            if (!simulate) {
                this.setEnergy(newEnergy);
            }
            return newEnergy - stored;
        }
        return 0;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        energy = Math.max(0, Math.min(energy, BlockEnergyBatteryConfig.energyPerTick));
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    protected int addEnergy(int energy) {
        int filled = this.addEnergyFe(energy, false);
        this.extractEnergy(filled, false);
        return filled;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.func_145831_w(), this.func_174877_v(), energy, simulate);
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K && this.getEnergyStored() > 0 && this.func_145831_w().func_175640_z(this.func_174877_v())) {
            this.addEnergy(Math.min(BlockEnergyBatteryConfig.energyPerTick, this.getEnergyStored()));
        }
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

