/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.charset.aspect;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integrateddynamicscompat.modcompat.charset.CharsetPipesModCompat;
import org.cyclops.integrateddynamicscompat.modcompat.charset.aspect.ShifterPart;
import pl.asie.charset.api.pipes.IPipeView;

public class CharsetAspects {

    public static final class Write {

        public static final class Pipe {
            public static final IAspectWriteActivator ACTIVATOR = new IAspectWriteActivator(){

                @Override
                public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
                    state.addVolatileCapability(CharsetPipesModCompat.SHIFTER, new ShifterPart<P, S>(target.getCenter().getSide(), partType, state));
                    Pipe.notifyNeighbours(target);
                }
            };
            public static final IAspectWriteDeactivator DEACTIVATOR = new IAspectWriteDeactivator(){

                @Override
                public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
                    state.removeVolatileCapability(CharsetPipesModCompat.SHIFTER);
                    Pipe.notifyNeighbours(target);
                }
            };
            public static final IAspectWrite<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> SHIFTER_BOOLEAN = Pipe.getShifter(AspectWriteBuilders.BUILDER_BOOLEAN.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeBoolean.ValueBoolean>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeBoolean.ValueBoolean> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    shifter.setShifting(((ValueTypeBoolean.ValueBoolean)input.getRight()).getRawValue());
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> SHIFTER_ITEMSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueObjectTypeItemStack.ValueItemStack>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueObjectTypeItemStack.ValueItemStack> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    shifter.setFilterItem(Collections.singleton(input.getRight()));
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> SHIFTER_LISTITEMSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_LIST.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeList.ValueList> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    if (((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() != ValueTypes.OBJECT_ITEMSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{new L10NHelpers.UnlocalizedString(ValueTypes.OBJECT_ITEMSTACK.getUnlocalizedName(), new Object[0]), new L10NHelpers.UnlocalizedString(((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType().getUnlocalizedName(), new Object[0])}).localize());
                    }
                    shifter.setFilterItem(((ValueTypeList.ValueList)input.getRight()).getRawValue());
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueTypeOperator.ValueOperator, ValueTypeOperator> SHIFTER_PREDICATEITEMSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_OPERATOR.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeOperator.ValueOperator>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeOperator.ValueOperator> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    IOperator predicate = OperatorBuilders.getSafePredictate((ValueTypeOperator.ValueOperator)input.getRight());
                    if (predicate.getInputTypes().length != 1 || !ValueHelpers.correspondsTo(predicate.getInputTypes()[0], ValueTypes.OBJECT_ITEMSTACK)) {
                        String current = ValueTypeOperator.getSignature(predicate);
                        String expected = ValueTypeOperator.getSignature(new IValueType[]{ValueTypes.OBJECT_ITEMSTACK}, ValueTypes.BOOLEAN);
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
                    }
                    shifter.setFilterItemPredicate(predicate);
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack> SHIFTER_FLUIDSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_FLUIDSTACK.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifterfluid")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueObjectTypeFluidStack.ValueFluidStack>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueObjectTypeFluidStack.ValueFluidStack> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    shifter.setFilterFluid(Collections.singleton(input.getRight()));
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> SHIFTER_LISTFLUIDSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_LIST.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifterfluid")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeList.ValueList> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    if (((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{new L10NHelpers.UnlocalizedString(ValueTypes.OBJECT_FLUIDSTACK.getUnlocalizedName(), new Object[0]), new L10NHelpers.UnlocalizedString(((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType().getUnlocalizedName(), new Object[0])}).localize());
                    }
                    shifter.setFilterFluid(((ValueTypeList.ValueList)input.getRight()).getRawValue());
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueTypeOperator.ValueOperator, ValueTypeOperator> SHIFTER_PREDICATEFLUIDSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_OPERATOR.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifterfluid")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeOperator.ValueOperator>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeOperator.ValueOperator> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    IOperator predicate = OperatorBuilders.getSafePredictate((ValueTypeOperator.ValueOperator)input.getRight());
                    if (predicate.getInputTypes().length != 1 || !ValueHelpers.correspondsTo(predicate.getInputTypes()[0], ValueTypes.OBJECT_FLUIDSTACK)) {
                        String current = ValueTypeOperator.getSignature(predicate);
                        String expected = ValueTypeOperator.getSignature(new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, ValueTypes.BOOLEAN);
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
                    }
                    shifter.setFilterFluidPredicate(predicate);
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();

            public static <V extends IValue, T extends IValueType<V>, O> AspectBuilder<V, T, Pair<ShifterPart, O>> getShifter(AspectBuilder<V, T, Triple<PartTarget, IAspectProperties, O>> builder) {
                return builder.handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, O>, Pair<ShifterPart, O>>(){

                    @Override
                    public Pair<ShifterPart, O> getOutput(Triple<PartTarget, IAspectProperties, O> input) throws EvaluationException {
                        PartPos center = ((PartTarget)input.getLeft()).getCenter();
                        return Pair.of((Object)((ShifterPart)TileHelpers.getCapability((World)center.getPos().getWorld(), (BlockPos)center.getPos().getBlockPos(), (EnumFacing)center.getSide(), CharsetPipesModCompat.SHIFTER)), (Object)input.getRight());
                    }
                });
            }

            protected static void notifyNeighbours(PartTarget target) {
                DimPos dimPos = target.getCenter().getPos();
                dimPos.getWorld().func_175685_c(dimPos.getBlockPos(), dimPos.getWorld().func_180495_p(dimPos.getBlockPos()).func_177230_c(), true);
            }
        }
    }

    public static final class Read {

        public static final class Pipe {
            public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IPipeView> PROP_GET = new IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IPipeView>(){

                @Override
                public IPipeView getOutput(Pair<PartTarget, IAspectProperties> input) {
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    return (IPipeView)TileHelpers.getCapability((DimPos)pos, CharsetPipesModCompat.PIPE);
                }
            };
            public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IPipeView> BUILDER_BOOLEAN = AspectReadBuilders.BUILDER_BOOLEAN.handle(PROP_GET, "charsetpipe");
            public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, IPipeView> BUILDER_OBJECT_ITEMSTACK = AspectReadBuilders.BUILDER_OBJECT_ITEMSTACK.handle(PROP_GET, "charsetpipe");
            public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, IPipeView> BUILDER_LIST = AspectReadBuilders.BUILDER_LIST.handle(PROP_GET, "charsetpipe");
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_ISAPPLICABLE = BUILDER_BOOLEAN.handle(new IAspectValuePropagator<IPipeView, Boolean>(){

                @Override
                public Boolean getOutput(IPipeView pipe) {
                    return pipe != null;
                }
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "applicable").buildRead();
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_HASCONTENTS = BUILDER_BOOLEAN.handle(new IAspectValuePropagator<IPipeView, Boolean>(){

                @Override
                public Boolean getOutput(IPipeView pipe) {
                    return pipe != null && !pipe.getTravellingStacks().isEmpty();
                }
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "hascontents").buildRead();
            public static final IAspectRead<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CONTENT = BUILDER_OBJECT_ITEMSTACK.handle(new IAspectValuePropagator<IPipeView, ItemStack>(){

                @Override
                public ItemStack getOutput(IPipeView pipe) {
                    if (pipe != null) {
                        return (ItemStack)Iterables.getFirst((Iterable)pipe.getTravellingStacks(), (Object)ItemStack.field_190927_a);
                    }
                    return ItemStack.field_190927_a;
                }
            }).handle(AspectReadBuilders.PROP_GET_ITEMSTACK, "content").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_CONTENTS = BUILDER_LIST.handle(new IAspectValuePropagator<IPipeView, ValueTypeList.ValueList>(){

                @Override
                public ValueTypeList.ValueList getOutput(IPipeView pipe) {
                    if (pipe != null) {
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Lists.newArrayList((Iterable)Iterables.transform((Iterable)pipe.getTravellingStacks(), (Function)new Function<ItemStack, ValueObjectTypeItemStack.ValueItemStack>(){

                            @Nullable
                            public ValueObjectTypeItemStack.ValueItemStack apply(ItemStack input) {
                                return ValueObjectTypeItemStack.ValueItemStack.of(input);
                            }
                        })));
                    }
                    return ValueTypeList.ValueList.ofAll((IValue[])new IValue[0]);
                }
            }).appendKind("contents").buildRead();
        }
    }
}

