/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.charset.aspect;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import pl.asie.charset.api.pipes.IShifter;

public class ShifterPart<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
implements IShifter {
    private final EnumFacing direction;
    private final P partType;
    private final S partState;
    private boolean shifting;
    private Iterable<ValueObjectTypeItemStack.ValueItemStack> filterItem;
    private Iterable<ValueObjectTypeFluidStack.ValueFluidStack> filterFluid;
    private IOperator filterItemPredicate;
    private IOperator filterFluidPredicate;

    public ShifterPart(EnumFacing direction, P partType, S partState) {
        this.direction = direction;
        this.partType = partType;
        this.partState = partState;
        this.shifting = false;
    }

    public IShifter.Mode getMode() {
        return IShifter.Mode.Shift;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public int getShiftDistance() {
        return Integer.MAX_VALUE;
    }

    public boolean isShifting() {
        return this.shifting;
    }

    public void setShifting(boolean shifting) {
        this.shifting = shifting;
    }

    public boolean hasFilter() {
        return this.filterItem != null || this.filterFluid != null || this.filterItemPredicate != null || this.filterFluidPredicate != null;
    }

    public void setFilterItem(Iterable<ValueObjectTypeItemStack.ValueItemStack> filterItem) {
        this.filterItem = filterItem;
    }

    public void setFilterFluid(Iterable<ValueObjectTypeFluidStack.ValueFluidStack> filterFluid) {
        this.filterFluid = filterFluid;
    }

    public void setFilterItemPredicate(IOperator filterItemPredicate) {
        this.filterItemPredicate = filterItemPredicate;
    }

    public void setFilterFluidPredicate(IOperator filterFluidPredicate) {
        this.filterFluidPredicate = filterFluidPredicate;
    }

    public boolean matches(ItemStack source) {
        if (this.filterItem != null) {
            for (ValueObjectTypeItemStack.ValueItemStack itemStack : this.filterItem) {
                if (itemStack.getRawValue().func_190926_b() || !ItemStackHelpers.areItemStacksIdentical((ItemStack)itemStack.getRawValue(), (ItemStack)source)) continue;
                return true;
            }
            return false;
        }
        if (this.filterItemPredicate != null) {
            ValueObjectTypeItemStack.ValueItemStack valueItemStack = ValueObjectTypeItemStack.ValueItemStack.of(source);
            try {
                IValue result = ValueHelpers.evaluateOperator(this.filterItemPredicate, valueItemStack);
                return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
            }
            catch (EvaluationException e) {
                this.partState.addError(this.partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                return false;
            }
        }
        return true;
    }

    public boolean matches(FluidStack source) {
        if (this.filterFluid != null) {
            for (ValueObjectTypeFluidStack.ValueFluidStack fluidStack : this.filterFluid) {
                FluidStack self;
                if (!fluidStack.getRawValue().isPresent() || ((self = (FluidStack)fluidStack.getRawValue().get()) != null || source != null) && (self == null || source == null || self.getFluid() != source.getFluid())) continue;
                return true;
            }
            return false;
        }
        if (this.filterFluidPredicate != null) {
            ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = ValueObjectTypeFluidStack.ValueFluidStack.of(source);
            try {
                IValue result = ValueHelpers.evaluateOperator(this.filterFluidPredicate, valueFluidStack);
                return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
            }
            catch (EvaluationException e) {
                this.partState.addError(this.partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                return false;
            }
        }
        return true;
    }
}

