/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.RSAPIInject;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.ValueTypeListProxyPositionedNetworkMasterFluidInventory;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.ValueTypeListProxyPositionedNetworkMasterItemInventory;

public class RefinedStorageAspects {
    @RSAPIInject
    public static IRSAPI RS;

    public static final class Write {
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROPERTY_SKIPCRAFTING = new AspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean>(ValueTypes.BOOLEAN, "aspect.aspecttypes.integrateddynamics.boolean.refinedstorage.skipcrafting.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROPERTY_SKIPSTORAGE = new AspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean>(ValueTypes.BOOLEAN, "aspect.aspecttypes.integrateddynamics.boolean.refinedstorage.skipstorage.name");
        public static final IAspectProperties CRAFTING_PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_SKIPCRAFTING, PROPERTY_SKIPSTORAGE));
        public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CRAFT;
        public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFT;
        public static final IAspectWrite<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_CANCELCRAFT;
        public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CANCELCRAFT;
        public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> LIST_CANCELCRAFT;

        protected static Void triggerItemStackCrafting(IAspectProperties aspectProperties, INetworkMaster networkMaster, ItemStack itemStack) {
            int compareFlags = 3;
            ICraftingPattern craftingPattern = networkMaster.getCraftingManager().getPattern(itemStack);
            if (craftingPattern != null) {
                ItemStack present;
                ICraftingTask craftingTask = networkMaster.getCraftingManager().create(itemStack, craftingPattern, 1, true);
                if (aspectProperties.getValue(PROPERTY_SKIPCRAFTING).getRawValue()) {
                    for (ICraftingTask task : networkMaster.getCraftingManager().getTasks()) {
                        for (ItemStack output : task.getPattern().getOutputs()) {
                            if (!RS.getComparer().isEqual(output, itemStack, compareFlags)) continue;
                            return null;
                        }
                    }
                }
                if (aspectProperties.getValue(PROPERTY_SKIPSTORAGE).getRawValue() && (present = (ItemStack)networkMaster.getItemStorageCache().getList().get((Object)itemStack, compareFlags)) != null && present.func_190916_E() >= itemStack.func_190916_E()) {
                    return null;
                }
                craftingTask.calculate();
                networkMaster.getCraftingManager().add(craftingTask);
            }
            return null;
        }

        static {
            CRAFTING_PROPERTIES.setValue(PROPERTY_SKIPCRAFTING, ValueTypeBoolean.ValueBoolean.of(true));
            CRAFTING_PROPERTIES.setValue(PROPERTY_SKIPSTORAGE, ValueTypeBoolean.ValueBoolean.of(false));
            ITEMSTACK_CRAFT = AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("refinedstorage").withProperties(CRAFTING_PROPERTIES).handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack> input) throws EvaluationException {
                    INetworkMaster networkMaster;
                    DimPos pos;
                    INetworkNode networkNode;
                    if (!((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue().func_190926_b() && (networkNode = (INetworkNode)TileHelpers.getSafeTile((DimPos)(pos = ((PartTarget)input.getLeft()).getTarget().getPos()), INetworkNode.class)) != null && (networkMaster = networkNode.getNetwork()) != null) {
                        ItemStack itemStack = ((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue();
                        return Write.triggerItemStackCrafting((IAspectProperties)input.getMiddle(), networkMaster, itemStack);
                    }
                    return null;
                }
            }, "craft").buildWrite();
            LIST_CRAFT = AspectWriteBuilders.BUILDER_LIST.appendKind("refinedstorage").withProperties(CRAFTING_PROPERTIES).handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList> input) throws EvaluationException {
                    INetworkMaster networkMaster;
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    INetworkNode networkNode = (INetworkNode)TileHelpers.getSafeTile((DimPos)pos, INetworkNode.class);
                    if (networkNode != null && (networkMaster = networkNode.getNetwork()) != null && ((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() == ValueTypes.OBJECT_ITEMSTACK) {
                        for (IValue value : ((ValueTypeList.ValueList)input.getRight()).getRawValue()) {
                            ValueObjectTypeItemStack.ValueItemStack valueItemStack = (ValueObjectTypeItemStack.ValueItemStack)value;
                            if (valueItemStack.getRawValue().func_190926_b()) continue;
                            ItemStack itemStack = valueItemStack.getRawValue();
                            Write.triggerItemStackCrafting((IAspectProperties)input.getMiddle(), networkMaster, itemStack);
                        }
                    }
                    return null;
                }
            }, "craft").buildWrite();
            BOOLEAN_CANCELCRAFT = AspectWriteBuilders.BUILDER_BOOLEAN.appendKind("refinedstorage").handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeBoolean.ValueBoolean>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueTypeBoolean.ValueBoolean> input) throws EvaluationException {
                    INetworkMaster networkMaster;
                    DimPos pos;
                    INetworkNode networkNode;
                    if (((ValueTypeBoolean.ValueBoolean)input.getRight()).getRawValue() && (networkNode = (INetworkNode)TileHelpers.getSafeTile((DimPos)(pos = ((PartTarget)input.getLeft()).getTarget().getPos()), INetworkNode.class)) != null && (networkMaster = networkNode.getNetwork()) != null) {
                        ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                        for (ICraftingTask craftingTask : craftingTasks) {
                            networkMaster.getCraftingManager().cancel(craftingTask);
                        }
                    }
                    return null;
                }
            }, "cancelcraft").buildWrite();
            ITEMSTACK_CANCELCRAFT = AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("refinedstorage").handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack> input) throws EvaluationException {
                    INetworkMaster networkMaster;
                    DimPos pos;
                    INetworkNode networkNode;
                    if (!((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue().func_190926_b() && (networkNode = (INetworkNode)TileHelpers.getSafeTile((DimPos)(pos = ((PartTarget)input.getLeft()).getTarget().getPos()), INetworkNode.class)) != null && (networkMaster = networkNode.getNetwork()) != null) {
                        ItemStack itemStack = ((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue();
                        ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                        int compareFlags = 3;
                        block0: for (ICraftingTask craftingTask : craftingTasks) {
                            for (ItemStack output : craftingTask.getPattern().getOutputs()) {
                                if (!RS.getComparer().isEqual(output, itemStack, compareFlags)) continue;
                                networkMaster.getCraftingManager().cancel(craftingTask);
                                continue block0;
                            }
                        }
                    }
                    return null;
                }
            }, "cancelcraft").buildWrite();
            LIST_CANCELCRAFT = AspectWriteBuilders.BUILDER_LIST.appendKind("refinedstorage").handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList> input) throws EvaluationException {
                    INetworkMaster networkMaster;
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    INetworkNode networkNode = (INetworkNode)TileHelpers.getSafeTile((DimPos)pos, INetworkNode.class);
                    if (networkNode != null && (networkMaster = networkNode.getNetwork()) != null && ((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() == ValueTypes.OBJECT_ITEMSTACK) {
                        ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                        int compareFlags = 3;
                        for (ICraftingTask craftingTask : craftingTasks) {
                            block1: for (ItemStack output : craftingTask.getPattern().getOutputs()) {
                                for (IValue value : ((ValueTypeList.ValueList)input.getRight()).getRawValue()) {
                                    ValueObjectTypeItemStack.ValueItemStack valueItemStack = (ValueObjectTypeItemStack.ValueItemStack)value;
                                    if (valueItemStack.getRawValue().func_190926_b() || !RS.getComparer().isEqual(output, valueItemStack.getRawValue(), compareFlags)) continue;
                                    networkMaster.getCraftingManager().cancel(craftingTask);
                                    continue block1;
                                }
                            }
                        }
                    }
                    return null;
                }
            }, "cancelcraft").buildWrite();
        }
    }

    public static final class Read {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, INetworkNode> PROP_GET_NODE = new IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, INetworkNode>(){

            @Override
            public INetworkNode getOutput(Pair<PartTarget, IAspectProperties> input) {
                DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                INetworkNodeProxy proxy = (INetworkNodeProxy)TileHelpers.getSafeTile((DimPos)pos, INetworkNodeProxy.class);
                if (proxy != null) {
                    return proxy.getNode();
                }
                return null;
            }
        };
        public static final IAspectValuePropagator<INetworkNode, INetworkMaster> PROP_GET_MASTER = new IAspectValuePropagator<INetworkNode, INetworkMaster>(){

            @Override
            public INetworkMaster getOutput(INetworkNode input) {
                return input != null ? input.getNetwork() : null;
            }
        };
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, INetworkMaster> BUILDER_BOOLEAN = AspectReadBuilders.BUILDER_BOOLEAN.handle(PROP_GET_NODE, "refinedstorage").handle(PROP_GET_MASTER);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, INetworkMaster> BUILDER_LIST = AspectReadBuilders.BUILDER_LIST.handle(PROP_GET_NODE, "refinedstorage").handle(PROP_GET_MASTER);

        public static final class Fluid {
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_FLUIDSTACKS = BUILDER_LIST.appendKind("fluid").handle(new IAspectValuePropagator<INetworkMaster, ValueTypeList.ValueList>(){

                @Override
                public ValueTypeList.ValueList getOutput(INetworkMaster networkMaster) {
                    if (networkMaster != null) {
                        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedNetworkMasterFluidInventory(DimPos.of((World)networkMaster.getNetworkWorld(), (BlockPos)networkMaster.getPosition())));
                    }
                    return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_FLUIDSTACK, Collections.emptyList());
                }
            }, "fluidstacks").buildRead();
        }

        public static final class Inventory {
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_ITEMSTACKS = BUILDER_LIST.appendKind("inventory").handle(new IAspectValuePropagator<INetworkMaster, ValueTypeList.ValueList>(){

                @Override
                public ValueTypeList.ValueList getOutput(INetworkMaster networkMaster) {
                    if (networkMaster != null) {
                        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedNetworkMasterItemInventory(DimPos.of((World)networkMaster.getNetworkWorld(), (BlockPos)networkMaster.getPosition())));
                    }
                    return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
                }
            }, "itemstacks").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFTABLEITEMS = BUILDER_LIST.appendKind("inventory").handle(new IAspectValuePropagator<INetworkMaster, ValueTypeList.ValueList>(){

                @Override
                public ValueTypeList.ValueList getOutput(INetworkMaster networkMaster) {
                    if (networkMaster != null) {
                        ArrayList itemStacks = Lists.newArrayList();
                        for (ICraftingPattern craftingPattern : networkMaster.getCraftingManager().getPatterns()) {
                            for (ItemStack itemStack : craftingPattern.getOutputs()) {
                                itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                            }
                        }
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, itemStacks);
                    }
                    return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
                }
            }, "craftableitems").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFTINGITEMS = BUILDER_LIST.appendKind("inventory").handle(new IAspectValuePropagator<INetworkMaster, ValueTypeList.ValueList>(){

                protected void addPatternItemStacks(List<ValueObjectTypeItemStack.ValueItemStack> itemStacks, ICraftingTask craftingTask) {
                    ICraftingPattern craftingPattern = craftingTask.getPattern();
                    for (ItemStack itemStack : craftingPattern.getOutputs()) {
                        itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                    }
                    for (ICraftingStep step : craftingTask.getSteps()) {
                        craftingPattern = step.getPattern();
                        for (ItemStack itemStack : craftingPattern.getOutputs()) {
                            itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                        }
                    }
                }

                @Override
                public ValueTypeList.ValueList getOutput(INetworkMaster networkMaster) {
                    if (networkMaster != null) {
                        ArrayList itemStacks = Lists.newArrayList();
                        for (ICraftingTask craftingTask : networkMaster.getCraftingManager().getTasks()) {
                            this.addPatternItemStacks(itemStacks, craftingTask);
                        }
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, itemStacks);
                    }
                    return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
                }
            }, "craftingitems").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_MISSINGCRAFTINGITEMS = BUILDER_LIST.appendKind("inventory").handle(new IAspectValuePropagator<INetworkMaster, ValueTypeList.ValueList>(){

                protected void addPatternItemStacksMissing(List<ValueObjectTypeItemStack.ValueItemStack> itemStacks, ICraftingTask craftingTask) {
                    for (ItemStack itemStack : craftingTask.getMissing().getStacks()) {
                        itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                    }
                }

                @Override
                public ValueTypeList.ValueList getOutput(INetworkMaster networkMaster) {
                    if (networkMaster != null) {
                        ArrayList itemStacks = Lists.newArrayList();
                        for (ICraftingTask craftingTask : networkMaster.getCraftingManager().getTasks()) {
                            this.addPatternItemStacksMissing(itemStacks, craftingTask);
                        }
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, itemStacks);
                    }
                    return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
                }
            }, "missingcraftingitems").buildRead();
        }

        public static final class Network {
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_APPLICABLE = BUILDER_BOOLEAN.appendKind("network").handle(new IAspectValuePropagator<INetworkMaster, Boolean>(){

                @Override
                public Boolean getOutput(INetworkMaster networkMaster) {
                    return networkMaster != null;
                }
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "applicable").buildRead();
        }
    }
}

