/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositioned;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.RefinedStorageModCompat;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.LazyCompositeList;

public class ValueTypeListProxyPositionedNetworkMasterFluidInventory
extends ValueTypeListProxyPositioned<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>
implements INBTProvider {
    public ValueTypeListProxyPositionedNetworkMasterFluidInventory() {
        this(null);
    }

    public ValueTypeListProxyPositionedNetworkMasterFluidInventory(DimPos pos) {
        super(RefinedStorageModCompat.POSITIONED_MASTERFLUIDINVENTORY.getName(), ValueTypes.OBJECT_FLUIDSTACK, pos, EnumFacing.NORTH);
    }

    protected Optional<INetworkMaster> getNetworkMaster() {
        return Optional.fromNullable((Object)TileHelpers.getSafeTile((DimPos)this.getPos(), INetworkMaster.class));
    }

    protected Optional<List<FluidStack>> getInventory() {
        return this.getNetworkMaster().transform((Function)new Function<INetworkMaster, List<FluidStack>>(){

            @Nullable
            public List<FluidStack> apply(@Nullable INetworkMaster networkMaster) {
                if (networkMaster == null) {
                    return null;
                }
                List fluidStacksLists = Lists.transform((List)networkMaster.getFluidStorageCache().getStorages(), (Function)new Function<IStorage<FluidStack>, List<FluidStack>>(){

                    @Nullable
                    public List<FluidStack> apply(@Nullable IStorage<FluidStack> fluidStorage) {
                        return fluidStorage.getStacks();
                    }
                });
                return new LazyCompositeList<FluidStack>(fluidStacksLists);
            }
        });
    }

    @Override
    public int getLength() {
        return ((List)this.getInventory().or(Collections.emptyList())).size();
    }

    @Override
    public ValueObjectTypeFluidStack.ValueFluidStack get(int index) {
        return ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)((List)this.getInventory().or(Collections.emptyList())).get(index));
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
    }
}

