/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IRecipeDefinition
extends Comparable<IRecipeDefinition> {
    public Set<IngredientComponent<?, ?>> getInputComponents();

    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> var1);

    public IMixedIngredients getOutput();

    public static NBTTagCompound serialize(IRecipeDefinition recipe) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inputTag = new NBTTagCompound();
        for (IngredientComponent<?, ?> component : recipe.getInputComponents()) {
            NBTTagList instances = new NBTTagList();
            for (IPrototypedIngredientAlternatives<?, ?> ingredient : recipe.getInputs(component)) {
                NBTTagCompound subTag = new NBTTagCompound();
                IPrototypedIngredientAlternatives.ISerializer<?> serializer = ingredient.getSerializer();
                subTag.func_74782_a("val", serializer.serialize(component, ingredient));
                subTag.func_74774_a("type", serializer.getId());
                instances.func_74742_a((NBTBase)subTag);
            }
            inputTag.func_74782_a(component.getRegistryName().toString(), (NBTBase)instances);
        }
        tag.func_74782_a("input", (NBTBase)inputTag);
        tag.func_74782_a("output", (NBTBase)IMixedIngredients.serialize(recipe.getOutput()));
        return tag;
    }

    public static RecipeDefinition deserialize(NBTTagCompound tag) throws IllegalArgumentException {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        if (!tag.func_74764_b("input")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid input tag");
        }
        if (!tag.func_74764_b("output")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid output tag");
        }
        NBTTagCompound inputTag = tag.func_74775_l("input");
        for (String componentName : inputTag.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            NBTBase subTag = inputTag.func_74781_a(componentName);
            if (!(subTag instanceof NBTTagList)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            NBTTagList instancesTag = (NBTTagList)subTag;
            ArrayList instances = Lists.newArrayList();
            for (NBTBase instanceTag : instancesTag) {
                NBTBase deserializeTag;
                IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesList<?, ?>> alternativeSerializer;
                if (instanceTag instanceof NBTTagList) {
                    alternativeSerializer = PrototypedIngredientAlternativesList.SERIALIZER;
                    deserializeTag = instanceTag;
                } else if (instanceTag instanceof NBTTagCompound) {
                    NBTTagCompound instanceTagCompound = (NBTTagCompound)instanceTag;
                    byte type = instanceTagCompound.func_74771_c("type");
                    alternativeSerializer = (IPrototypedIngredientAlternatives.ISerializer)IPrototypedIngredientAlternatives.SERIALIZERS.get(type);
                    if (alternativeSerializer == null) {
                        throw new IllegalArgumentException("Could not find a prototyped ingredient alternative serializer for id " + type);
                    }
                    deserializeTag = ((NBTTagCompound)instanceTag).func_74781_a("val");
                } else {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid reference to instances");
                }
                Object alternatives = alternativeSerializer.deserialize(component, deserializeTag);
                instances.add(alternatives);
            }
            inputs.put(component, instances);
        }
        MixedIngredients output = IMixedIngredients.deserialize(tag.func_74775_l("output"));
        return new RecipeDefinition(inputs, output);
    }
}

