/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.tconstruct.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;

public abstract class TileCastingRecipeHandler
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return (component == IngredientComponent.ITEMSTACK || component == IngredientComponent.FLUIDSTACK) && size <= 1;
    }

    protected void putRecipeItemStackInputs(Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs, CastingRecipe recipeCasting) {
        List inputItems;
        if (recipeCasting.cast != null && !(inputItems = recipeCasting.cast.getInputs()).isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, inputItems.stream().map(input -> new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)input, 15)}))).collect(Collectors.toList()));
        }
    }

    protected abstract List<ICastingRecipe> getCastingRecipes();

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        return this.getCastingRecipes().stream().filter(recipe -> recipe instanceof CastingRecipe).map(recipe -> {
            CastingRecipe recipeCasting = (CastingRecipe)recipe;
            IdentityHashMap inputs = Maps.newIdentityHashMap();
            IdentityHashMap outputs = Maps.newIdentityHashMap();
            this.putRecipeItemStackInputs(inputs, recipeCasting);
            inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, recipeCasting.getFluid(), 7)}))}));
            outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipeCasting.getResult()}));
            return new RecipeDefinition(inputs, new MixedIngredients(outputs));
        }).collect(Collectors.toList());
    }

    protected abstract ICastingRecipe getCastingRecipe(ItemStack var1, Fluid var2);

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        FluidStack fluidStack;
        Fluid fluid;
        ItemStack itemStack = input.getFirstNonEmpty(IngredientComponent.ITEMSTACK);
        ICastingRecipe recipe = this.getCastingRecipe(itemStack, fluid = (fluidStack = input.getFirstNonEmpty(IngredientComponent.FLUIDSTACK)) != null ? fluidStack.getFluid() : null);
        if (recipe == null || recipe.getFluidAmount() < FluidHelpers.getAmount((FluidStack)fluidStack)) {
            return null;
        }
        IdentityHashMap ingredientsMap = Maps.newIdentityHashMap();
        ingredientsMap.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getResult(itemStack, fluid)}));
        return new MixedIngredients(ingredientsMap);
    }
}

