/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;

public class SingleUseTank
extends Tank {
    public static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private Fluid acceptedFluid;

    public SingleUseTank(int capacity, TileEntity tile) {
        super(capacity, tile);
    }

    @Deprecated
    public SingleUseTank(String name, int capacity, TileEntity tile) {
        super(name, capacity, tile);
    }

    @Deprecated
    public SingleUseTank(String name, int capacity, CyclopsTileEntity tile) {
        super(name, capacity, tile);
    }

    public int fill(FluidStack resource, boolean doFill) {
        Fluid acceptedFluid = this.getAcceptedFluid();
        int filled = 0;
        if (resource == null) {
            filled = 0;
        } else {
            if (doFill && acceptedFluid == null) {
                acceptedFluid = resource.getFluid();
            }
            if (acceptedFluid == null || acceptedFluid == resource.getFluid()) {
                filled = super.fill(resource, doFill);
            }
        }
        if (filled > 0) {
            this.sendUpdate();
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (drained != null) {
            this.sendUpdate();
        }
        return drained;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = super.drain(resource, doDrain);
        if (drained != null) {
            this.sendUpdate();
        }
        return drained;
    }

    protected void sendUpdate() {
        if (this.tile instanceof IUpdateListener) {
            ((IUpdateListener)this.tile).onTankChanged();
        } else if (!(this.tile instanceof TankInventoryTileEntity) || ((TankInventoryTileEntity)this.tile).isSendUpdateOnTankChanged()) {
            if (this.tile instanceof TankInventoryTileEntity) {
                ((TankInventoryTileEntity)this.tile).onTankChanged();
            } else if (this.tile instanceof CyclopsTileEntity) {
                ((CyclopsTileEntity)this.tile).sendUpdate();
            }
        }
    }

    public void reset() {
        this.acceptedFluid = null;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = fluid;
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        if (this.acceptedFluid != null) {
            nbt.func_74778_a(NBT_ACCEPTED_FLUID, this.acceptedFluid.getName());
        }
    }

    @Override
    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        this.acceptedFluid = FluidRegistry.getFluid((String)nbt.func_74779_i(NBT_ACCEPTED_FLUID));
    }

    public boolean canFillFluidType(FluidStack fluid) {
        Fluid fluidType = fluid != null ? fluid.getFluid() : null;
        return super.canFillFluidType(fluid) && (fluidType == this.getAcceptedFluid() || this.getAcceptedFluid() == null);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        Fluid fluidType = fluid != null ? fluid.getFluid() : null;
        return super.canDrainFluidType(fluid) && (fluidType == this.getAcceptedFluid() || this.getAcceptedFluid() == null);
    }

    public static interface IUpdateListener {
        public void onTankChanged();
    }
}

