/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.cyclopscore.network.packet.RequestPlayerAdvancementUnlockedPacket;

public class AdvancementHelpers {
    public static final Set<ResourceLocation> ACHIEVED_ADVANCEMENTS = Sets.newHashSet();

    public static boolean hasAdvancementUnlocked(EntityPlayer player, Advancement advancement) {
        return player instanceof EntityPlayerMP && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_192054_h((EntityPlayerMP)player).func_192747_a(advancement).func_192105_a();
    }

    public static boolean hasAdvancementUnlocked(EntityPlayer player, ResourceLocation advancementId) {
        return ACHIEVED_ADVANCEMENTS.contains(advancementId);
    }

    public static void requestAdvancementUnlockInfo(ResourceLocation advancementId) {
        CyclopsCore._instance.getPacketHandler().sendToServer(new RequestPlayerAdvancementUnlockedPacket(advancementId.toString()));
    }

    public static Advancement getAdvancement(ResourceLocation resourceLocation) {
        if (MinecraftHelpers.isClientSide()) {
            return AdvancementHelpers.getAdvancementManagerClient().func_194229_a().func_192084_a(resourceLocation);
        }
        return AdvancementHelpers.getAdvancementManagerServer().func_192778_a(resourceLocation);
    }

    public static AdvancementManager getAdvancementManagerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK();
    }

    public static ClientAdvancementManager getAdvancementManagerClient() {
        return Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f();
    }

    public static <T extends ICriterionTrigger<?>> T registerCriteriaTrigger(T criterion) {
        return ObfuscationHelpers.registerCriteriaTrigger(criterion);
    }
}

