/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProviderConfigurable;

public abstract class ItemGui
extends ConfigurableItem
implements IGuiContainerProviderConfigurable {
    private int guiID;

    protected ItemGui(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.guiID = Helpers.getNewId(eConfig.getMod(), Helpers.IDType.GUI);
    }

    @Override
    public ModBase getModGui() {
        return this.eConfig.getMod();
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public abstract Class<? extends Container> getContainer();

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract Class<? extends GuiScreen> getGui();

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer player) {
        if (itemstack != null && player instanceof EntityPlayerMP && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainer()) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    @Deprecated
    public void openGuiForItemIndex(World world, EntityPlayer player, int itemIndex) {
        this.openGuiForItemIndex(world, player, itemIndex, EnumHand.MAIN_HAND);
    }

    public void openGuiForItemIndex(World world, EntityPlayer player, int itemIndex, EnumHand hand) {
        this.getConfig().getMod().getGuiHandler().setTemporaryData(GuiHandler.GuiType.ITEM, Pair.of((Object)itemIndex, (Object)hand));
        if (!world.field_72995_K || this.isClientSideOnlyGui()) {
            player.openGui((Object)this.getConfig().getMod(), this.getGuiID(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    protected boolean isClientSideOnlyGui() {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player instanceof FakePlayer || player.getClass().getName().equals("ffba04.blockhologram.dummy.DummyPlayer")) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        this.openGuiForItemIndex(world, player, player.field_71071_by.field_70461_c, hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }
}

