/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.crafttweaker.handlers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreIngredient;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.modcompat.crafttweaker.handlers.RecipeRegistryAddition;
import org.cyclops.cyclopscore.modcompat.crafttweaker.handlers.RecipeRegistryRemoval;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public abstract class RecipeRegistryHandler<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> {
    protected abstract M getMachine();

    protected abstract String getRegistryName();

    public void add(IRecipe<I, O, P> recipe) {
        CraftTweakerAPI.apply(new RecipeRegistryAddition<M, I, O, P>(this.getRegistryName(), this.getMachine(), recipe));
    }

    public void remove(IRecipe<I, O, P> recipe) {
        CraftTweakerAPI.apply(new RecipeRegistryRemoval(this.getRegistryName(), this.getMachine(), recipe));
    }

    public void remove(O output) {
        CraftTweakerAPI.apply(new RecipeRegistryRemoval(this.getRegistryName(), this.getMachine(), output));
    }

    public static ItemStack toStack(IItemStack stack) {
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = stack.getInternal();
        if (!(internal instanceof ItemStack)) {
            CyclopsCore.clog("Not a valid item stack: " + stack);
            return null;
        }
        return (ItemStack)internal;
    }

    public static Ingredient toIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return Ingredient.field_193370_a;
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName());
        }
        if (ingredient instanceof IItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeRegistryHandler.toStack((IItemStack)ingredient)});
        }
        if (ingredient instanceof IngredientStack) {
            return Ingredient.func_193369_a((ItemStack[])((ItemStack[])((IngredientStack)ingredient).getItems().stream().map(RecipeRegistryHandler::toStack).toArray(ItemStack[]::new)));
        }
        CyclopsCore.clog("Not a valid ingredient: " + ingredient);
        return Ingredient.field_193370_a;
    }

    public static FluidStack toFluid(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)stack.getName(), (int)stack.getAmount());
    }
}

