/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPath;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerFilterExpression
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_EXPRESSION = Pattern.compile("^\\[\\?\\(([^\\)^\\(]+)\\)\\]");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = REGEX_EXPRESSION.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String expressionString = matcher.group(1);
        try {
            INbtPathExpression expression = NbtPath.parse(expressionString);
            return new INbtPathExpressionParseHandler.HandleResult(new Expression(expression), 5 + expressionString.length());
        }
        catch (NbtParseException e) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
    }

    public static class Expression
    implements INbtPathExpression {
        private final INbtPathExpression expression;

        public Expression(INbtPathExpression expression) {
            this.expression = expression;
        }

        public INbtPathExpression getExpression() {
            return this.expression;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                NBTBase nbt = executionContext.getCurrentTag();
                if (nbt.func_74732_a() == 9) {
                    NBTTagList tag = (NBTTagList)nbt;
                    NBTTagList newTagList = new NBTTagList();
                    StreamSupport.stream(tag.spliterator(), false).filter(subTag -> this.getExpression().test((NBTBase)subTag)).forEach(arg_0 -> ((NBTTagList)newTagList).func_74742_a(arg_0));
                    return new NbtPathExpressionExecutionContext((NBTBase)newTagList, (NbtPathExpressionExecutionContext)executionContext);
                }
                if (nbt.func_74732_a() == 10) {
                    NBTTagCompound tag = (NBTTagCompound)nbt;
                    NBTTagList newTagList = new NBTTagList();
                    tag.func_150296_c().stream().map(arg_0 -> ((NBTTagCompound)tag).func_74781_a(arg_0)).filter(subTag -> this.getExpression().test((NBTBase)subTag)).forEach(arg_0 -> ((NBTTagList)newTagList).func_74742_a(arg_0));
                    return new NbtPathExpressionExecutionContext((NBTBase)newTagList, (NbtPathExpressionExecutionContext)executionContext);
                }
                return null;
            }).filter(Objects::nonNull));
        }
    }
}

