/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.Recipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.CommonRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class GridRecipeTypeHandler
extends CommonRecipeTypeHandler<IngredientsRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent> {
    @Override
    public String getCategoryId() {
        return "crafting_recipe";
    }

    @Override
    public IRecipe<IngredientsRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent> loadRecipe(RecipeHandler recipeHandler, Node recipe) {
        Element recipeElement = (Element)recipe;
        Element input = (Element)recipeElement.getElementsByTagName("input").item(0);
        Element output = (Element)recipeElement.getElementsByTagName("output").item(0);
        ItemStack[] outputStacks = this.getIngredient(recipeHandler, output.getElementsByTagName("item").item(0)).func_193365_a();
        if (outputStacks.length == 0) {
            throw new XmlRecipeLoader.XmlRecipeException("No matching output stacks were found for '" + output.getElementsByTagName("item").item(0).getTextContent() + "'");
        }
        ItemStack outputItemStack = outputStacks[0];
        NonNullList<Ingredient> ingredients = this.handleIO(recipeHandler, input, outputItemStack);
        return new Recipe<IngredientsRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent>(new IngredientsRecipeComponent(ingredients), new IngredientRecipeComponent(outputItemStack));
    }

    protected abstract NonNullList<Ingredient> handleIO(RecipeHandler var1, Element var2, ItemStack var3) throws XmlRecipeLoader.XmlRecipeException;
}

