/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.ingredient;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.IIngredientComponentCapabilityAttacher;
import org.cyclops.commoncapabilities.api.ingredient.capability.IngredientComponentCapabilityAttacherAdapter;
import org.cyclops.commoncapabilities.api.ingredient.capability.IngredientComponentCapabilityAttacherManager;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.capability.ingredient.IngredientComponentValueHandlerConfig;
import org.cyclops.integrateddynamics.capability.ingredient.IngredientComponentValueHandlerEnergy;
import org.cyclops.integrateddynamics.capability.ingredient.IngredientComponentValueHandlerFluidStack;
import org.cyclops.integrateddynamics.capability.ingredient.IngredientComponentValueHandlerItemStack;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.PositionedAddonsNetworkIngredientsHandlerConfig;

public class IngredientComponentCapabilities {
    public static final ResourceLocation INGREDIENT_ITEMSTACK_NAME = new ResourceLocation("minecraft", "itemstack");
    public static final ResourceLocation INGREDIENT_FLUIDSTACK_NAME = new ResourceLocation("minecraft", "fluidstack");
    public static final ResourceLocation INGREDIENT_ENERGY_NAME = new ResourceLocation("minecraft", "energy");

    public static void load() {
        IngredientComponentCapabilityAttacherManager attacherManager = new IngredientComponentCapabilityAttacherManager();
        ResourceLocation capabilityIngredientComponentValueHandler = new ResourceLocation("integrateddynamics", "ingredientComponentValueHandler");
        attacherManager.addAttacher((IIngredientComponentCapabilityAttacher)new IngredientComponentCapabilityAttacherAdapter<ItemStack, Integer>(INGREDIENT_ITEMSTACK_NAME, capabilityIngredientComponentValueHandler){

            public ICapabilityProvider createCapabilityProvider(IngredientComponent<ItemStack, Integer> ingredientComponent) {
                return new DefaultCapabilityProvider(() -> IngredientComponentValueHandlerConfig.CAPABILITY, (Object)new IngredientComponentValueHandlerItemStack(ingredientComponent));
            }
        });
        attacherManager.addAttacher((IIngredientComponentCapabilityAttacher)new IngredientComponentCapabilityAttacherAdapter<FluidStack, Integer>(INGREDIENT_FLUIDSTACK_NAME, capabilityIngredientComponentValueHandler){

            public ICapabilityProvider createCapabilityProvider(IngredientComponent<FluidStack, Integer> ingredientComponent) {
                return new DefaultCapabilityProvider(() -> IngredientComponentValueHandlerConfig.CAPABILITY, (Object)new IngredientComponentValueHandlerFluidStack(ingredientComponent));
            }
        });
        attacherManager.addAttacher((IIngredientComponentCapabilityAttacher)new IngredientComponentCapabilityAttacherAdapter<Integer, Boolean>(INGREDIENT_ENERGY_NAME, capabilityIngredientComponentValueHandler){

            public ICapabilityProvider createCapabilityProvider(IngredientComponent<Integer, Boolean> ingredientComponent) {
                return new DefaultCapabilityProvider(() -> IngredientComponentValueHandlerConfig.CAPABILITY, (Object)new IngredientComponentValueHandlerEnergy(ingredientComponent));
            }
        });
        ResourceLocation networkHandler = new ResourceLocation("integrateddynamics", "networkHandler");
        attacherManager.addAttacher((IIngredientComponentCapabilityAttacher)new IngredientComponentCapabilityAttacherAdapter<Integer, Boolean>(INGREDIENT_ENERGY_NAME, networkHandler){

            public ICapabilityProvider createCapabilityProvider(IngredientComponent<Integer, Boolean> ingredientComponent) {
                return new DefaultCapabilityProvider(() -> PositionedAddonsNetworkIngredientsHandlerConfig.CAPABILITY, network -> network.getCapability(EnergyNetworkConfig.CAPABILITY));
            }
        });
    }
}

