/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.client.model.BakedMapVariableModelProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeVariableModelProvider
implements IVariableModelProvider<BakedMapVariableModelProvider<IValueType>> {
    @Override
    public BakedMapVariableModelProvider<IValueType> bakeOverlayModels(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashMap bakedModels = Maps.newHashMap();
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            try {
                ResourceLocation resourceLocation = ValueTypes.REGISTRY.getValueTypeModel(valueType);
                if (resourceLocation == null) continue;
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)resourceLocation);
                IBakedModel bakedValueTypeModel = model.bake(state, format, bakedTextureGetter);
                bakedModels.put(valueType, bakedValueTypeModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BakedMapVariableModelProvider<IValueType>(bakedModels);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ValueTypes.REGISTRY.getValueTypeModels();
    }
}

