/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.metadata.RegistryExportableOperator;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class RegistryExportableAspect
implements IRegistryExportable {
    public JsonObject export() {
        JsonObject element = new JsonObject();
        for (IAspect aspect : Aspects.REGISTRY.getAspects()) {
            JsonObject object = new JsonObject();
            object.addProperty("name", aspect.getTranslationKey());
            object.addProperty("description", aspect.getTranslationKey().substring(0, aspect.getTranslationKey().length() - 5) + ".info");
            object.addProperty("type", aspect instanceof IAspectWrite ? "write" : "read");
            if (aspect instanceof IAspectWrite) {
                object.add("input", (JsonElement)RegistryExportableOperator.serializeValueType(aspect.getValueType()));
            } else {
                object.add("output", (JsonElement)RegistryExportableOperator.serializeValueType(aspect.getValueType()));
            }
            JsonArray properties = new JsonArray();
            for (IAspectPropertyTypeInstance propertyType : aspect.getPropertyTypes()) {
                properties.add(propertyType.getTranslationKey());
            }
            object.add("properties", (JsonElement)properties);
            element.add(aspect.getTranslationKey(), (JsonElement)object);
        }
        return element;
    }

    public String getName() {
        return "aspect";
    }
}

