/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.FileUtil;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";
    private static final String PRESET_FLAT_WORLD = "minecraft:bedrock,3*minecraft:stone,52*minecraft:sandstone;minecraft:desert;";

    @SubscribeEvent
    public static void onMainMenuInit(GuiScreenEvent.InitGuiEvent event) {
        if (GeneralConfig.devWorldButton && event.getGui() instanceof MainMenuScreen) {
            event.addWidget((Widget)new Button(event.getGui().width / 2 + 102, event.getGui().height / 4 + 48, 58, 20, L10NHelpers.localize("general.cyclopscore.dev_world", new Object[0]), button -> {
                Minecraft mc = Minecraft.func_71410_x();
                if (!MinecraftHelpers.isShifted()) {
                    WorldSummary devWorldSummary = null;
                    mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    try {
                        for (WorldSummary worldSummary : mc.func_71359_d().func_75799_b()) {
                            if (!worldSummary.func_75788_b().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.func_75784_e() >= worldSummary.func_75784_e()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (AnvilConverterException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.func_147108_a((Screen)new ErrorScreen((ITextComponent)new TranslationTextComponent("selectWorld.unable_to_load", new Object[0]), e.getMessage()));
                    }
                    if (devWorldSummary != null && mc.func_71359_d().func_90033_f(devWorldSummary.func_75786_a())) {
                        ClientHooks.tryLoadExistingWorld((WorldSelectionScreen)new WorldSelectionScreen((Screen)new MainMenuScreen()), (WorldSummary)devWorldSummary);
                        return;
                    }
                }
                WorldSettings worldsettings = new WorldSettings((long)new Random().nextInt(), GameType.CREATIVE, false, false, WorldType.field_77138_c);
                worldsettings.func_77166_b();
                worldsettings.func_205390_a((JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)FlatGenerationSettings.func_82651_a((String)PRESET_FLAT_WORLD).func_210834_a((DynamicOps)NBTDynamicOps.field_210820_a).getValue()));
                String saveName = null;
                try {
                    saveName = FileUtil.func_214992_a((Path)mc.func_71359_d().func_215781_c(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.func_71371_a(saveName, WORLD_NAME_PREFIX, worldsettings);
            }));
        }
    }

    @SubscribeEvent
    public static void onWorldStart(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d() && event.getWorld().func_72912_H().func_76065_j().equals(WORLD_NAME_PREFIX)) {
            ((GameRules.BooleanValue)event.getWorld().func_72912_H().func_82574_x().func_223585_a(GameRules.field_223607_j)).func_223570_a(false, null);
        }
    }
}

