/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class WidgetNumberField
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowUp;
    private ButtonArrow arrowDown;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    public WidgetNumberField(FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, String narrationMessage, boolean background) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new ButtonArrow(x, y + height / 2, "gui.cyclopscore.up", button -> this.increase(), ButtonArrow.Direction.NORTH);
            this.arrowDown = new ButtonArrow(x, y + height / 2, "gui.cyclopscore.down", button -> this.decrease(), ButtonArrow.Direction.SOUTH);
            this.arrowUp.y -= this.arrowUp.getHeight();
        }
        this.func_146185_a(true);
        this.func_146180_a("0");
    }

    public void func_146184_c(boolean enabled) {
        this.arrowUp.active = enabled;
        this.arrowDown.active = enabled;
        this.isEnabled = enabled;
        super.func_146184_c(enabled);
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.setMinValue(positiveOnly ? 0 : Integer.MIN_VALUE);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.updateArrowsState();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInt() throws NumberFormatException {
        return this.validateNumber(Integer.parseInt(this.func_146179_b()));
    }

    public double getDouble() throws NumberFormatException {
        return this.validateNumber(Double.parseDouble(this.func_146179_b()));
    }

    public float getFloat() throws NumberFormatException {
        return this.validateNumber(Float.parseFloat(this.func_146179_b()));
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.arrows) {
            this.arrowUp.renderButton(mouseX, mouseY, partialTicks);
            this.arrowDown.renderButton(mouseX, mouseY, partialTicks);
            offsetX = this.arrowUp.getWidth();
            this.x += offsetX;
            this.width -= offsetX;
        }
        super.renderButton(mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.x -= offsetX;
            this.width += offsetX;
        }
    }

    public int validateNumber(int number) {
        return Math.max(this.minValue, Math.min(this.maxValue, number));
    }

    public double validateNumber(double number) {
        return Math.max((double)this.minValue, Math.min((double)this.maxValue, number));
    }

    public float validateNumber(float number) {
        return Math.max((float)this.minValue, Math.min((float)this.maxValue, number));
    }

    protected int getDiffAmount() {
        return MinecraftHelpers.isShifted() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
        this.updateArrowsState();
    }

    protected void decrease() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
        this.updateArrowsState();
    }

    @Override
    public void func_146180_a(String value) {
        super.func_146180_a(value);
        this.updateArrowsState();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        boolean ret = super.charTyped(typedChar, keyCode);
        this.updateArrowsState();
        return ret;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        boolean ret = super.keyPressed(typedChar, keyCode, modifiers);
        this.updateArrowsState();
        return ret;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean ret = this.arrowUp.mouseClicked(mouseX, mouseY, mouseButton) || this.arrowDown.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
        this.updateArrowsState();
        return ret;
    }

    protected void updateArrowsState() {
        if (this.arrows) {
            this.arrowDown.active = true;
            this.arrowUp.active = true;
            try {
                if (this.getInt() <= this.minValue) {
                    this.arrowDown.active = false;
                }
                if (this.getInt() >= this.maxValue) {
                    this.arrowUp.active = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

