/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemInformationProvider;

public abstract class BlockConfig
extends ExtendedConfigForge<BlockConfig, Block>
implements IModelProviderConfig {
    private final BiFunction<BlockConfig, Block, ? extends Item> itemConstructor;
    @Nullable
    private Item itemInstance;
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation dynamicBlockVariantLocation;
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation dynamicItemVariantLocation;

    public BlockConfig(ModBase mod, String namedId, Function<BlockConfig, ? extends Block> blockConstructor, @Nullable BiFunction<BlockConfig, Block, ? extends Item> itemConstructor) {
        super(mod, namedId, blockConstructor);
        this.itemConstructor = itemConstructor;
    }

    protected static BiFunction<BlockConfig, Block, ? extends BlockItem> getDefaultItemConstructor(ModBase mod) {
        return BlockConfig.getDefaultItemConstructor(mod, null);
    }

    protected static BiFunction<BlockConfig, Block, ? extends BlockItem> getDefaultItemConstructor(ModBase mod, @Nullable Function<Item.Properties, Item.Properties> itemPropertiesModifier) {
        return (eConfig, block) -> {
            Item.Properties itemProperties = new Item.Properties().func_200916_a(mod.getDefaultItemGroup());
            if (itemPropertiesModifier != null) {
                itemProperties = (Item.Properties)itemPropertiesModifier.apply(itemProperties);
            }
            return new BlockItem(block, itemProperties);
        };
    }

    public BiFunction<BlockConfig, Block, ? extends Item> getItemConstructor() {
        return this.itemConstructor;
    }

    @Nullable
    public Item getItemInstance() {
        return this.itemInstance;
    }

    public void setItemInstance(@Nullable Item itemInstance) {
        this.itemInstance = itemInstance;
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getTranslationKey() {
        return "block." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Pair<ModelResourceLocation, ModelResourceLocation> registerDynamicModel() {
        String blockName = this.getMod().getModId() + ":" + this.getNamedId();
        ModelResourceLocation blockLocation = new ModelResourceLocation(blockName, "");
        ModelResourceLocation itemLocation = new ModelResourceLocation(blockName, "inventory");
        return Pair.of((Object)blockLocation, (Object)itemLocation);
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        if (MinecraftHelpers.isClientSide() && this.getInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)this.getInstance()).hasDynamicModel()) {
            BlockAction.handleDynamicBlockModel(this);
        }
    }

    @Override
    public void onForgeRegistered() {
        super.onForgeRegistered();
        Item item = this.getItemInstance();
        if (item != null) {
            ItemInformationProvider.registerItem(item);
        }
    }

    @Override
    public IForgeRegistry<Block> getRegistry() {
        return ForgeRegistries.BLOCKS;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IBlockColor getBlockColorHandler() {
        return null;
    }
}

