/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class EntityConfig<T extends Entity>
extends ExtendedConfigForge<EntityConfig<T>, EntityType<T>> {
    public EntityConfig(ModBase mod, String namedId, Function<EntityConfig<T>, EntityType.Builder<T>> elementConstructor) {
        super(mod, namedId, elementConstructor.andThen(builder -> builder.func_206830_a(mod.getModId() + ":" + namedId)));
    }

    @Override
    public String getTranslationKey() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.ENTITY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)this.getInstance()), manager -> this.getRender(manager, Minecraft.func_71410_x().func_175599_af()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityRenderer<? super T> getRender(EntityRendererManager var1, ItemRenderer var2);

    @Override
    public IForgeRegistry<EntityType<?>> getRegistry() {
        return ForgeRegistries.ENTITIES;
    }
}

