/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientSetMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionCollectionWrappedAdapter;

public abstract class IngredientSet<T, M>
extends IngredientCollectionCollectionWrappedAdapter<T, M, Set<IngredientInstanceWrapper<T, M>>>
implements IIngredientSetMutable<T, M> {
    public IngredientSet(IngredientComponent<T, M> component, Set<IngredientInstanceWrapper<T, M>> set) {
        super(component, set);
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getExactMatchCondition(), matchCondition)) {
            return this.remove(instance) ? 1 : 0;
        }
        return super.removeAll(instance, matchCondition);
    }

    @Override
    public boolean contains(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getExactMatchCondition(), matchCondition)) {
            return this.contains(instance);
        }
        return super.contains(instance, matchCondition);
    }

    @Override
    public int count(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getExactMatchCondition(), matchCondition)) {
            return this.contains(instance) ? 1 : 0;
        }
        return super.count(instance, matchCondition);
    }

    @Override
    public Iterator<T> iterator(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getExactMatchCondition(), matchCondition)) {
            return this.contains(instance) ? new ExactIterator<T>(instance, this) : Iterators.forArray((Object[])new Object[0]);
        }
        return super.iterator(instance, matchCondition);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IngredientSet that = (IngredientSet)obj;
        return this.getComponent() == that.getComponent() && this.size() == that.size() && this.containsAll(that);
    }

    protected static class ExactIterator<T>
    implements Iterator<T> {
        private final T instance;
        private final IIngredientCollectionMutable<T, ?> collection;
        private boolean nexted;
        private boolean removed;

        public ExactIterator(T instance, IIngredientCollectionMutable<T, ?> collection) {
            this.instance = instance;
            this.collection = collection;
        }

        @Override
        public boolean hasNext() {
            return !this.nexted;
        }

        @Override
        public T next() {
            if (this.nexted) {
                throw new NoSuchElementException("Tried reading a finished ExactIterator");
            }
            this.nexted = true;
            return this.instance;
        }

        @Override
        public void remove() {
            if (!this.nexted) {
                throw new IllegalStateException("The next method was not called yet");
            }
            if (this.removed) {
                throw new IllegalStateException("The remove method has already been called on this element");
            }
            this.removed = true;
            this.collection.remove(this.instance);
        }
    }
}

