/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public abstract class PlayerPositionPacket
extends PacketCodec {
    private static final int DEFAULT_RANGE = 3000;
    @CodecField
    protected String uuid;
    @CodecField
    protected Vec3d position = new Vec3d(0.0, 0.0, 0.0);
    @CodecField
    private int range = 3000;

    public PlayerPositionPacket() {
    }

    public PlayerPositionPacket(PlayerEntity player) {
        this(player, 3000);
    }

    public PlayerPositionPacket(PlayerEntity player, int range) {
        this.uuid = player.func_110124_au().toString();
        this.position = player.func_174791_d();
        this.range = range;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (this.uuid == null) {
            this.getModInstance().log(Level.WARN, "Got PlayerPositionPacket with empty uuid");
            return;
        }
        try {
            UUID uuid = UUID.fromString(this.uuid);
            if (player != null && !player.func_110124_au().equals(uuid)) {
                player = world.func_217371_b(uuid);
            }
            if (player == null) {
                this.getModInstance().log(Level.WARN, "Received PlayerPositionPacket for player with uuid '" + uuid + "', but player doesn't exist");
            } else {
                this.performClientAction(world, player);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void actionServer(World world, ServerPlayerEntity player) {
        this.getModInstance().getPacketHandler().sendToAllAround(this.create((PlayerEntity)player, this.range), LocationHelpers.createTargetPointFromEntity((Entity)player, this.range));
    }

    protected abstract PlayerPositionPacket create(PlayerEntity var1, int var2);

    protected abstract ModBase getModInstance();

    protected abstract void performClientAction(World var1, PlayerEntity var2);
}

