/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.icon.IconProvider;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ClientProxyComponent
extends CommonProxyComponent
implements ICommonProxy,
IClientProxy {
    private final CommonProxyComponent commonProxyComponent;
    private final IconProvider iconProvider;
    protected final Map<TileEntityType<?>, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<?>>> tileEntityRenderers = Maps.newHashMap();

    public ClientProxyComponent(CommonProxyComponent commonProxyComponent) {
        this.commonProxyComponent = commonProxyComponent;
        this.iconProvider = this.constructIconProvider();
    }

    protected IconProvider constructIconProvider() {
        return new IconProvider(this);
    }

    @Override
    public <T extends TileEntity> void registerRenderer(TileEntityType<T> tileEntityType, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>> rendererFactory) {
        this.tileEntityRenderers.put(tileEntityType, rendererFactory);
    }

    @Override
    public void registerRenderers() {
        for (Map.Entry<TileEntityType<?>, Function<TileEntityRendererDispatcher, TileEntityRenderer<?>>> entry : this.tileEntityRenderers.entrySet()) {
            ClientRegistry.bindTileEntityRenderer(entry.getKey(), entry.getValue());
            this.getMod().getLoggerHelper().log(Level.TRACE, String.format("Registered %s special renderer %s", entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void registerKeyBindings(IKeyRegistry keyRegistry) {
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered key bindings");
    }

    @Override
    public void registerPacketHandlers(PacketHandler packetHandler) {
        this.commonProxyComponent.registerPacketHandlers(packetHandler);
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered packet handlers");
    }

    @Override
    public void registerTickHandlers() {
        this.commonProxyComponent.registerTickHandlers();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered tick handlers");
    }

    @Override
    public void registerEventHooks() {
        this.commonProxyComponent.registerEventHooks();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered event hooks");
        MinecraftForge.EVENT_BUS.register((Object)this.getMod().getKeyRegistry());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProxyComponent)) {
            return false;
        }
        ClientProxyComponent other = (ClientProxyComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonProxyComponent this$commonProxyComponent = this.getCommonProxyComponent();
        CommonProxyComponent other$commonProxyComponent = other.getCommonProxyComponent();
        if (this$commonProxyComponent == null ? other$commonProxyComponent != null : !this$commonProxyComponent.equals(other$commonProxyComponent)) {
            return false;
        }
        IconProvider this$iconProvider = this.getIconProvider();
        IconProvider other$iconProvider = other.getIconProvider();
        if (this$iconProvider == null ? other$iconProvider != null : !this$iconProvider.equals(other$iconProvider)) {
            return false;
        }
        Map<TileEntityType<?>, Function<TileEntityRendererDispatcher, TileEntityRenderer<?>>> this$tileEntityRenderers = this.getTileEntityRenderers();
        Map<TileEntityType<?>, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<?>>> other$tileEntityRenderers = other.getTileEntityRenderers();
        return !(this$tileEntityRenderers == null ? other$tileEntityRenderers != null : !((Object)this$tileEntityRenderers).equals(other$tileEntityRenderers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProxyComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonProxyComponent $commonProxyComponent = this.getCommonProxyComponent();
        result = result * 59 + ($commonProxyComponent == null ? 0 : $commonProxyComponent.hashCode());
        IconProvider $iconProvider = this.getIconProvider();
        result = result * 59 + ($iconProvider == null ? 0 : $iconProvider.hashCode());
        Map<TileEntityType<?>, Function<TileEntityRendererDispatcher, TileEntityRenderer<?>>> $tileEntityRenderers = this.getTileEntityRenderers();
        result = result * 59 + ($tileEntityRenderers == null ? 0 : ((Object)$tileEntityRenderers).hashCode());
        return result;
    }

    public CommonProxyComponent getCommonProxyComponent() {
        return this.commonProxyComponent;
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public Map<TileEntityType<?>, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<?>>> getTileEntityRenderers() {
        return this.tileEntityRenderers;
    }

    public String toString() {
        return "ClientProxyComponent(commonProxyComponent=" + this.getCommonProxyComponent() + ", iconProvider=" + this.getIconProvider() + ", tileEntityRenderers=" + this.getTileEntityRenderers() + ")";
    }
}

