/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities;

import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.GeneralConfig;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.capability.ingredient.storage.IngredientComponentStorageHandlerConfig;
import org.cyclops.commoncapabilities.capability.inventorystate.InventoryStateConfig;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;
import org.cyclops.commoncapabilities.capability.recipehandler.RecipeHandlerConfig;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.modcompat.vanilla.VanillaModCompat;
import org.cyclops.commoncapabilities.proxy.ClientProxy;
import org.cyclops.commoncapabilities.proxy.CommonProxy;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

@Mod(value="commoncapabilities")
public class CommonCapabilities
extends ModBaseVersionable<CommonCapabilities> {
    public static CommonCapabilities _instance;

    public CommonCapabilities() {
        super("commoncapabilities", instance -> {
            _instance = instance;
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegister);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat((IModCompat)new VanillaModCompat());
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected ItemGroup constructDefaultItemGroup() {
        return null;
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new WorkerConfig());
        configHandler.addConfigurable((ExtendedConfig)new TemperatureConfig());
        configHandler.addConfigurable((ExtendedConfig)new InventoryStateConfig());
        configHandler.addConfigurable((ExtendedConfig)new SlotlessItemHandlerConfig());
        configHandler.addConfigurable((ExtendedConfig)new RecipeHandlerConfig());
        configHandler.addConfigurable((ExtendedConfig)new IngredientComponentStorageHandlerConfig());
    }

    public void onRegister(RegistryEvent.Register event) {
        if (event.getRegistry() == IngredientComponent.REGISTRY) {
            IPrototypedIngredientAlternatives.SERIALIZERS.put(PrototypedIngredientAlternativesList.SERIALIZER.getId(), (Object)PrototypedIngredientAlternativesList.SERIALIZER);
            IPrototypedIngredientAlternatives.SERIALIZERS.put(PrototypedIngredientAlternativesItemStackTag.SERIALIZER.getId(), (Object)PrototypedIngredientAlternativesItemStackTag.SERIALIZER);
            event.getRegistry().registerAll(new IForgeRegistryEntry[]{IngredientComponents.ITEMSTACK, IngredientComponents.FLUIDSTACK, IngredientComponents.ENERGY});
        }
    }

    public static void clog(String message) {
        CommonCapabilities.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

