/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.NBTIngredient;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public class VanillaRecipeTypeRecipeHandler<C extends IInventory, T extends IRecipe<C>>
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    public static final Container DUMMY_CONTAINTER = new Container(ContainerType.field_221518_l, 0){

        public boolean func_75145_c(PlayerEntity playerIn) {
            return true;
        }
    };
    private final Supplier<World> worldSupplier;
    private final IRecipeType<T> recipeType;
    private final Predicate<Integer> inputSizePredicate;

    public VanillaRecipeTypeRecipeHandler(Supplier<World> worldSupplier, IRecipeType<T> recipeType, Predicate<Integer> inputSizePredicate) {
        this.worldSupplier = worldSupplier;
        this.recipeType = recipeType;
        this.inputSizePredicate = inputSizePredicate;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && this.inputSizePredicate.test(size);
    }

    public static List<IPrototypedIngredient<ItemStack, Integer>> getPrototypesFromIngredient(Ingredient ingredient) {
        if (ingredient instanceof NBTIngredient) {
            return Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ingredient.func_193365_a()[0], 5)});
        }
        return Arrays.stream(ingredient.func_193365_a()).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 1)).collect(Collectors.toList());
    }

    @Nullable
    public static <C extends IInventory, T extends IRecipe<C>> IRecipeDefinition recipeToRecipeDefinition(T recipe) {
        if (recipe.func_77571_b().func_190926_b()) {
            return null;
        }
        int inputSize = recipe.func_192400_c().size();
        ArrayList inputIngredients = Lists.newArrayListWithCapacity((int)inputSize);
        if (inputSize == 0) {
            return null;
        }
        for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            List<IPrototypedIngredient<ItemStack, Integer>> prototypes = VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(ingredient);
            if (prototypes.isEmpty()) {
                prototypes.add(new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.field_190927_a, 1));
            }
            inputIngredients.add(i, prototypes);
        }
        return RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, inputIngredients, MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.func_77571_b()));
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        return this.worldSupplier.get().func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == this.recipeType).map(VanillaRecipeTypeRecipeHandler::recipeToRecipeDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (input.getComponents().size() != 1 || recipeIngredients.size() < 1) {
            return null;
        }
        int rows = 2;
        int columns = 2;
        if (recipeIngredients.size() > 4) {
            rows = 3;
            columns = 3;
        }
        CraftingInventory inventoryCrafting = new CraftingInventory(DUMMY_CONTAINTER, rows, columns);
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            inventoryCrafting.func_70299_a(i, recipeIngredients.get(i));
        }
        IRecipe recipe = CraftingHelpers.findRecipeCached(this.recipeType, (IInventory)inventoryCrafting, (World)this.worldSupplier.get(), (boolean)true).orElse(null);
        if (recipe == null) {
            return null;
        }
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.func_77571_b());
    }
}

