/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.block.BlockTileGui;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.tileentity.TileDryingBasin;

public class BlockDryingBasin
extends BlockTileGui {
    private static final VoxelShape SHAPE_RAYTRACE = BlockDryingBasin.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)BlockDryingBasin.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockDryingBasin.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockDryingBasin.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), SHAPE_RAYTRACE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public BlockDryingBasin(Block.Properties properties) {
        super(properties, TileDryingBasin::new);
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDryingBasin.class).map(tile -> {
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            IFluidHandler itemFluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            SingleUseTank tank = tile.getTank();
            ItemStack tileStack = tile.getInventory().func_70301_a(0);
            if (itemStack.func_190926_b() && !tileStack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                tile.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
            if (player.field_71071_by.func_70441_a(tileStack)) {
                tile.getInventory().func_70299_a(0, ItemStack.field_190927_a);
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isFull() && FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)false).isSuccess()) {
                ItemStack newItemStack = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true).getResult();
                InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isEmpty() && FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)false).isSuccess()) {
                ItemStack newItemStack = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true).getResult();
                InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                return ActionResultType.SUCCESS;
            }
            if (!itemStack.func_190926_b() && tileStack.func_190926_b()) {
                tile.getInventory().func_70299_a(0, itemStack.func_77979_a(1));
                if (itemStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                tile.sendUpdate();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    public boolean func_220081_d(BlockState blockState, IBlockReader world, BlockPos blockPos) {
        return false;
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDryingBasin.class).map(tile -> tile.getInventory().func_70301_a(0) != null ? 15 : 0).orElse(0);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState blockState, IBlockReader world, BlockPos blockPos) {
        return SHAPE_RAYTRACE;
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileDryingBasin.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((World)world, (IInventory)tile.getInventory(), (BlockPos)blockPos);
                world.func_175666_e(blockPos, oldState.func_177230_c());
            });
            super.func_196243_a(oldState, world, blockPos, newState, isMoving);
        }
    }
}

