/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.block.BlockDelayConfig;
import org.cyclops.integrateddynamics.core.client.gui.ContainerScreenActiveVariableBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerDelay;

public class ContainerScreenDelay
extends ContainerScreenActiveVariableBase<ContainerDelay> {
    private static final int ERROR_X = 110;
    private static final int ERROR_Y = 26;
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldCapacity = null;

    public ContainerScreenDelay(ContainerDelay container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/delay.png");
    }

    protected int getBaseYSize() {
        return 227;
    }

    @Override
    protected int getErrorX() {
        return 110;
    }

    @Override
    protected int getErrorY() {
        return 26;
    }

    public void init() {
        super.init();
        this.numberFieldUpdateInterval = new WidgetNumberField(this.font, this.field_147003_i + 98, this.field_147009_r + 102, 73, 14, true, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), true);
        this.numberFieldUpdateInterval.setPositiveOnly(true);
        this.numberFieldUpdateInterval.func_146203_f(64);
        this.numberFieldUpdateInterval.func_146203_f(15);
        this.numberFieldUpdateInterval.func_146189_e(true);
        this.numberFieldUpdateInterval.func_146193_g(0xFFFFFF);
        this.numberFieldUpdateInterval.func_146205_d(true);
        this.numberFieldCapacity = new WidgetNumberField(this.font, this.field_147003_i + 98, this.field_147009_r + 126, 73, 14, true, L10NHelpers.localize((String)"gui.integrateddynamics.delay.capacity", (Object[])new Object[0]), true);
        this.numberFieldCapacity.setMinValue(1);
        this.numberFieldCapacity.setMaxValue(BlockDelayConfig.maxHistoryCapacity);
        this.numberFieldCapacity.func_146203_f(64);
        this.numberFieldCapacity.func_146203_f(15);
        this.numberFieldCapacity.func_146189_e(true);
        this.numberFieldCapacity.func_146193_g(0xFFFFFF);
        this.numberFieldCapacity.func_146205_d(true);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.numberFieldUpdateInterval.charTyped(typedChar, keyCode) && !this.numberFieldCapacity.charTyped(typedChar, keyCode)) {
            return super.charTyped(typedChar, keyCode);
        }
        this.onValueChanged();
        return true;
    }

    protected void onValueChanged() {
        int updateInterval = 1;
        int capacity = 5;
        try {
            updateInterval = this.numberFieldUpdateInterval.getInt();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            capacity = this.numberFieldCapacity.getInt();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerDelay)this.func_212873_a_()).getLastUpdateValueId(), (int)updateInterval);
        ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerDelay)this.func_212873_a_()).getLastCapacityValueId(), (int)capacity);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.numberFieldUpdateInterval.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.onValueChanged();
            return true;
        }
        if (this.numberFieldCapacity.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.onValueChanged();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.numberFieldUpdateInterval.renderButton(mouseX - this.field_147003_i, mouseY - this.field_147009_r, partialTicks);
        this.numberFieldCapacity.renderButton(mouseX - this.field_147003_i, mouseY - this.field_147009_r, partialTicks);
        this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 104), Helpers.RGBToInt((int)0, (int)0, (int)0));
        this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.delay.capacity", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 128), Helpers.RGBToInt((int)0, (int)0, (int)0));
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        if (valueId == ((ContainerDelay)this.func_212873_a_()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.func_146180_a(Integer.toString(((ContainerDelay)this.func_212873_a_()).getLastUpdateValue()));
        }
        if (valueId == ((ContainerDelay)this.func_212873_a_()).getLastCapacityValueId()) {
            this.numberFieldCapacity.func_146180_a(Integer.toString(((ContainerDelay)this.func_212873_a_()).getLastCapacityValue()));
        }
    }
}

