/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public abstract class CableModelBase
extends DelegatingDynamicItemAndBlockModel {
    private static final Cache<Triple<IRenderState, Direction, RenderType>, List<BakedQuad>> CACHE_QUADS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final int RADIUS = 4;
    private static final int TEXTURE_SIZE = 16;
    private static final int LENGTH_CONNECTION = 6;
    private static final int LENGTH_CONNECTION_LIMITED = 1;
    private static final int INV_LENGTH_CONNECTION = 10;
    public static final float MIN = 0.375f;
    public static final float MAX = 0.625f;
    private static final PartRenderPosition CABLE_RENDERPOSITION = new PartRenderPosition(-1.0f, 0.375f, 0.25f, 0.25f);
    private final float[][][] quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f);
    protected static final ItemCameraTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.03125f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.03125f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f))));

    public CableModelBase(BlockState blockState, Direction facing, Random rand, IModelData modelData) {
        super(blockState, facing, rand, modelData);
    }

    public CableModelBase(ItemStack itemStack, World world, LivingEntity entity) {
        super(itemStack, world, entity);
    }

    public CableModelBase() {
    }

    protected static float[][][] makeQuadVertexes(float min, float max, float length) {
        return new float[][][]{new float[][]{{min, length, min}, {max, length, min}, {max, max, min}, {min, max, min}}, new float[][]{{min, max, min}, {min, max, max}, {min, length, max}, {min, length, min}}, new float[][]{{min, max, max}, {max, max, max}, {max, length, max}, {min, length, max}}, new float[][]{{max, length, min}, {max, length, max}, {max, max, max}, {max, max, min}}};
    }

    private Direction getSideFromVecs(Vec3d a, Vec3d b, Vec3d c) {
        int dir;
        int n = a.field_72448_b == b.field_72448_b && b.field_72448_b == c.field_72448_b ? 0 : (dir = a.field_72450_a == b.field_72450_a && b.field_72450_a == c.field_72450_a ? 2 : 4);
        if (dir == 0) {
            dir += c.field_72448_b >= 0.5 ? 1 : 0;
        } else if (dir == 2) {
            dir += c.field_72450_a >= 0.5 ? 1 : 0;
        } else if (dir == 4) {
            dir += c.field_72449_c >= 0.5 ? 1 : 0;
        }
        return Direction.func_82600_a((int)dir);
    }

    public List<BakedQuad> getFacadeQuads(BlockState blockState, Direction side, PartRenderPosition partRenderPosition) {
        LinkedList ret = Lists.newLinkedList();
        IBakedModel model = RenderHelpers.getBakedModel((BlockState)blockState);
        TextureAtlasSprite texture = model.func_177554_e();
        if (partRenderPosition == PartRenderPosition.NONE) {
            CableModelBase.addBakedQuad((List)ret, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
        } else {
            float w = partRenderPosition.getWidthFactorSide();
            float h = partRenderPosition.getHeightFactorSide();
            float x0 = 0.0f;
            float x1 = (1.0f - w) / 2.0f;
            float x2 = x1 + w;
            float x3 = 1.0f;
            float z0 = 0.0f;
            float z1 = (1.0f - h) / 2.0f;
            float z2 = z1 + h;
            float z3 = 1.0f;
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x1, (float)x2, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z1, (float)z2, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z1, (float)z2, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x1, (float)x2, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (Direction)side);
        }
        return ret;
    }

    protected abstract boolean isRealCable(IModelData var1);

    protected abstract Optional<BlockState> getFacade(IModelData var1);

    protected abstract boolean isConnected(IModelData var1, Direction var2);

    protected abstract boolean hasPart(IModelData var1, Direction var2);

    protected abstract PartRenderPosition getPartRenderPosition(IModelData var1, Direction var2);

    protected abstract boolean shouldRenderParts(IModelData var1);

    protected abstract IBakedModel getPartModel(IModelData var1, Direction var2);

    protected abstract IRenderState getRenderState(IModelData var1);

    public List<BakedQuad> getGeneralQuads() {
        IRenderState renderState;
        Triple cacheKey = null;
        List cachedQuads = null;
        if (GeneralConfig.cacheCableModels && (renderState = this.getRenderState(this.modelData)) != null) {
            cacheKey = Triple.of((Object)renderState, (Object)this.facing, (Object)MinecraftForgeClient.getRenderLayer());
            cachedQuads = (List)CACHE_QUADS.getIfPresent((Object)cacheKey);
        }
        if (cachedQuads == null) {
            boolean isConnected;
            LinkedList ret = Lists.newLinkedList();
            TextureAtlasSprite texture = this.func_177554_e();
            boolean renderCable = this.isItemStack() || this.isRealCable(this.modelData) && MinecraftForgeClient.getRenderLayer() == RenderType.func_228639_c_();
            Optional<BlockState> blockStateHolder = this.getFacade(this.modelData);
            for (Direction side : Direction.values()) {
                boolean hasPart;
                isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                if (hasPart && this.shouldRenderParts(this.modelData)) {
                    try {
                        ret.addAll(this.getPartModel(this.modelData, side).getQuads(this.blockState, this.facing, this.rand, this.modelData));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!renderCable) continue;
                if (isConnected || hasPart) {
                    int i = 0;
                    float[][][] quadVertexes = this.quadVertexes;
                    if (hasPart) {
                        PartRenderPosition partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                        float depthFactor = partRenderPosition == PartRenderPosition.NONE ? 0.0f : partRenderPosition.getDepthFactor();
                        quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f - depthFactor);
                    }
                    for (float[][] v : quadVertexes) {
                        Vec3d v1 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[0][0] - 0.5, (double)v[0][1] - 0.5, (double)v[0][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v2 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[1][0] - 0.5, (double)v[1][1] - 0.5, (double)v[1][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v3 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[2][0] - 0.5, (double)v[2][1] - 0.5, (double)v[2][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vec3d v4 = CableModelBase.rotate((Vec3d)new Vec3d((double)v[3][0] - 0.5, (double)v[3][1] - 0.5, (double)v[3][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Direction realSide = this.getSideFromVecs(v1, v2, v3);
                        boolean invert = i == 2 || i == 1;
                        int length = hasPart ? 1 : 6;
                        int[] data = Ints.concat((int[][])new int[][]{CableModelBase.vertexToInts((float)((float)v1.field_72450_a), (float)((float)v1.field_72448_b), (float)((float)v1.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v2.field_72450_a), (float)((float)v2.field_72448_b), (float)((float)v2.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v3.field_72450_a), (float)((float)v3.field_72448_b), (float)((float)v3.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? 0.0f : (float)length)), CableModelBase.vertexToInts((float)((float)v4.field_72450_a), (float)((float)v4.field_72448_b), (float)((float)v4.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? 0.0f : (float)length))});
                        ++i;
                        ForgeHooksClient.fillNormal((int[])data, (Direction)realSide);
                        ret.add(new BakedQuad(data, -1, realSide, texture, true));
                    }
                    continue;
                }
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)0.625f, (TextureAtlasSprite)texture, (Direction)side);
            }
            if (blockStateHolder.isPresent() && this.shouldRenderParts(this.modelData)) {
                for (Direction side : Direction.values()) {
                    boolean hasPart;
                    isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                    PartRenderPosition partRenderPosition = PartRenderPosition.NONE;
                    boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                    if (hasPart) {
                        partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                    } else if (isConnected) {
                        partRenderPosition = CABLE_RENDERPOSITION;
                    }
                    ret.addAll(this.getFacadeQuads(blockStateHolder.get(), side, partRenderPosition));
                }
            }
            if (this.isItemStack()) {
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.EAST);
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.WEST);
            }
            cachedQuads = ret;
            if (cacheKey != null) {
                CACHE_QUADS.put((Object)cacheKey, (Object)cachedQuads);
            }
        }
        return cachedQuads;
    }

    public TextureAtlasSprite func_177554_e() {
        return RegistryEntries.BLOCK_CABLE.texture;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileMultipartTicking.class).map(TileMultipartTicking::getConnectionState).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public boolean func_230044_c_() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return TRANSFORMS;
    }
}

