/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class RenderTileEntityEnergyBattery
extends TileEntityRenderer<TileEnergyBattery> {
    private static final float OFFSET = 0.001f;
    private static final float MINY = 0.0f;
    private static final float MAXY = 1.0f;
    private static final float MIN = -0.001f;
    private static final float MAX = 1.001f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 0.0f, 1.001f}, {1.001f, 0.0f, 1.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{-0.001f, 1.0f, -0.001f}, {-0.001f, 1.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 1.0f, -0.001f}}, new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 1.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 0.0f, 1.001f}}, new float[][]{{-0.001f, 0.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, -0.001f}, {-0.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 0.0f, 1.001f}}};

    public RenderTileEntityEnergyBattery(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(TileEnergyBattery tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null && tile.getEnergyStored() > 0) {
            float height = (float)tile.getEnergyStored() / (float)tile.getMaxEnergyStored();
            height = height * 12.0f / 16.0f + 0.125f;
            matrixStack.func_227860_a_();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                combinedLight = WorldRenderer.func_228421_a_((ILightReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v().func_177971_a(side.func_176730_m()));
                TextureAtlasSprite icon = RegistryEntries.BLOCK_ENERGY_BATTERY.iconOverlay;
                float[][] c = coordinates[side.ordinal()];
                float replacedMaxV = icon.func_94210_h();
                float replacedMinV = (icon.func_94206_g() - icon.func_94210_h()) * height + icon.func_94210_h();
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (tile.isCreative()) {
                    float tickFactor = (float)tile.func_145831_w().func_82737_E() % 20.0f / 10.0f;
                    if (tickFactor > 1.0f) {
                        tickFactor = -tickFactor + 1.0f;
                    }
                    r = 0.8f + 0.2f * tickFactor;
                    g = 0.42f;
                    b = 0.6f + 0.4f * tickFactor;
                }
                IVertexBuilder vb = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                vb.func_227888_a_(matrix, c[0][0], c[0][1] * height, c[0][2]).func_227885_a_(r, g, b, 1.0f).func_225583_a_(icon.func_94209_e(), replacedMaxV).func_227886_a_(combinedLight).func_181675_d();
                vb.func_227888_a_(matrix, c[1][0], c[1][1] * height, c[1][2]).func_227885_a_(r, g, b, 1.0f).func_225583_a_(icon.func_94209_e(), replacedMinV).func_227886_a_(combinedLight).func_181675_d();
                vb.func_227888_a_(matrix, c[2][0], c[2][1] * height, c[2][2]).func_227885_a_(r, g, b, 1.0f).func_225583_a_(icon.func_94212_f(), replacedMinV).func_227886_a_(combinedLight).func_181675_d();
                vb.func_227888_a_(matrix, c[3][0], c[3][1] * height, c[3][2]).func_227885_a_(r, g, b, 1.0f).func_225583_a_(icon.func_94212_f(), replacedMaxV).func_227886_a_(combinedLight).func_181675_d();
            }
            matrixStack.func_227865_b_();
        }
    }
}

