/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;

public class CommandTest
implements Command<CommandSource> {
    private static final String P = "org.cyclops.integrateddynamics.core.evaluate.variable.integration.";
    public static final List<String> CLASSES = ImmutableList.of((Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestVariables", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestBlockOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestItemStackOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestEntityOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestFluidStackOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestIngredientsOperators", (Object)"org.cyclops.integrateddynamics.core.evaluate.variable.integration.TestRecipeOperators");

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent("Running tests..."));
        try {
            if (!this.test()) {
                ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent("There were failing tests, see results in console."));
            } else {
                ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent("All tests succeeded!"));
            }
            return 0;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return 1;
        }
    }

    protected boolean test() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        int ok = 0;
        int total = 0;
        for (String className : CLASSES) {
            Class<?> clazz = Class.forName(className);
            Object testInstance = clazz.newInstance();
            LinkedList befores = Lists.newLinkedList();
            HashMap tests = Maps.newHashMap();
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(IntegrationBefore.class)) {
                    befores.add(method);
                }
                if (!method.isAnnotationPresent(IntegrationTest.class)) continue;
                tests.put(method, false);
            }
            for (Method test : tests.keySet()) {
                boolean testOk;
                String testName = className.replace(P, "") + "#" + test.getName();
                for (Method before : befores) {
                    before.invoke(testInstance, new Object[0]);
                }
                try {
                    test.invoke(testInstance, new Object[0]);
                    testOk = true;
                }
                catch (InvocationTargetException e) {
                    Class<?> excepted = test.getAnnotation(IntegrationTest.class).expected();
                    if (!excepted.isInstance(e.getTargetException())) {
                        testOk = false;
                        if (e.getTargetException() instanceof IllegalStateException || e.getTargetException() instanceof AssertionError) {
                            System.err.println("Test " + testName + " failed!");
                            e.getTargetException().printStackTrace();
                        } else {
                            System.err.println(String.format("Expected at %s exception %s, but found:", testName, e));
                            e.getTargetException().printStackTrace();
                        }
                    }
                    testOk = true;
                }
                tests.put(test, testOk);
            }
            for (Boolean result : tests.values()) {
                if (!result.booleanValue()) continue;
                ++ok;
            }
            total += tests.size();
        }
        System.err.println(String.format("Tests succeeded: %s/%s", ok, total));
        return ok == total;
    }

    public static LiteralArgumentBuilder<CommandSource> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires(commandSource -> commandSource.func_197034_c(2))).executes((Command)new CommandTest());
    }
}

