/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;

public abstract class BlockContainerCabled
extends BlockTile {
    public BlockContainerCabled(Block.Properties properties, Supplier<CyclopsTileEntity> tileEntitySupplier) {
        super(properties, tileEntitySupplier);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.func_201670_d() && WrenchHelpers.isWrench(player, heldItem, world, pos, blockRayTraceResult.func_216354_b()) && player.func_213453_ef()) {
            world.func_175655_b(pos, true);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        if (!world.func_201670_d()) {
            CableHelpers.onCableAdded(world, pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (!world.func_201670_d()) {
            CableHelpers.onCableAddedByPlayer(world, pos, placer);
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        CableHelpers.onCableRemoving((World)world, blockPos, true, false);
        Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables((World)world, blockPos);
        super.func_176206_d(world, blockPos, blockState);
        CableHelpers.onCableRemoved((World)world, blockPos, connectedCables);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos blockPos, Explosion explosion) {
        CableHelpers.onCableRemoving(world, blockPos, true, false);
        Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
        CableHelpers.onCableRemoved(world, blockPos, connectedCables);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, isMoving);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock, null, fromPos);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof World) {
            NetworkHelpers.onElementProviderBlockNeighborChange((World)world, pos, world.func_180495_p(neighbor).func_177230_c(), null, neighbor);
        }
    }

    public void observedNeighborChange(BlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, observerPos, changedBlock, null, changedBlockPos);
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c() && newState.func_196958_f()) {
            CableHelpers.onCableRemoving(world, blockPos, true, false);
            Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
            super.func_196243_a(oldState, world, blockPos, newState, isMoving);
            CableHelpers.onCableRemoved(world, blockPos, connectedCables);
        } else {
            super.func_196243_a(oldState, world, blockPos, newState, isMoving);
        }
    }
}

