/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;

public class WidgetTextFieldDropdown<T>
extends WidgetTextFieldExtended {
    private final Set<IDropdownEntry<T>> possibilities;
    private List<IDropdownEntry<T>> visiblePossibilities = Collections.emptyList();
    private int visiblePossibilitiesIndex = -1;
    private IDropdownEntry<T> selectedDropdownPossibility = null;
    private int dropdownSize = 5;
    private IDropdownEntryListener<T> dropdownEntryListener;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public WidgetTextFieldDropdown(FontRenderer fontrenderer, int x, int y, int width, int height, String narrationMessage, boolean background, Set<IDropdownEntry<T>> possibilities) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.possibilities = Objects.requireNonNull(possibilities);
    }

    public WidgetTextFieldDropdown(FontRenderer fontrenderer, int x, int y, int width, int height, String narrationMessage, boolean background) {
        this(fontrenderer, x, y, width, height, narrationMessage, background, Collections.emptySet());
    }

    protected void refreshDropdownList() {
        if (this.func_146179_b().contains("\u00a7")) {
            this.func_146180_a(this.func_146179_b().replaceAll("\u00a7.", ""));
        }
        if (!this.possibilities.isEmpty()) {
            this.visiblePossibilities = Lists.newArrayList();
            for (IDropdownEntry<T> possibility : this.possibilities) {
                if (!possibility.getMatchString().toLowerCase().contains(this.func_146179_b().toLowerCase())) continue;
                this.visiblePossibilities.add(possibility);
            }
            this.visiblePossibilitiesIndex = -1;
            if (this.visiblePossibilities.size() == 1 && this.visiblePossibilities.get(0).getMatchString().equals(this.func_146179_b())) {
                this.selectedDropdownPossibility = this.visiblePossibilities.get(0);
            }
            if (this.dropdownEntryListener != null) {
                this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
            }
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (super.charTyped(typedChar, keyCode)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        this.selectedDropdownPossibility = null;
        if (!this.possibilities.isEmpty()) {
            switch (typedChar) {
                case 265: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex >= 0 ? --this.visiblePossibilitiesIndex : this.visiblePossibilities.size() - 1;
                    return true;
                }
                case 258: 
                case 264: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex < this.visiblePossibilities.size() - 1 ? ++this.visiblePossibilitiesIndex : 0;
                    return true;
                }
                case 257: 
                case 262: 
                case 335: {
                    if (this.visiblePossibilitiesIndex < 0 || this.visiblePossibilitiesIndex >= this.visiblePossibilities.size()) break;
                    this.selectVisiblePossibility(this.visiblePossibilitiesIndex);
                    return true;
                }
            }
        }
        if (super.keyPressed(typedChar, keyCode, modifiers)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    protected void selectVisiblePossibility(int index) {
        this.visiblePossibilitiesIndex = index;
        this.selectPossibility(this.visiblePossibilities.get(this.visiblePossibilitiesIndex));
    }

    public void selectPossibility(IDropdownEntry<T> entry) {
        this.selectedDropdownPossibility = entry;
        this.func_146180_a(this.selectedDropdownPossibility.getDisplayString());
        this.visiblePossibilities = Lists.newArrayList();
        this.visiblePossibilitiesIndex = -1;
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
        }
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        super.renderButton(mouseX, mouseY, partialTicks);
        if (this.func_146176_q() && this.isFocused()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            fontRenderer.getClass();
            int yOffset = 9 + 3;
            int x = this.x;
            int y = this.y + yOffset;
            int width = this.getWidth() + 9;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            if (startIndex > 0) {
                WidgetTextFieldDropdown.fill((int)x, (int)(cy - 1), (int)(x + width), (int)(cy + 11), (int)-6250336);
                WidgetTextFieldDropdown.fill((int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + 10), (int)-16777216);
                fontRenderer.func_175063_a("...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor);
                cy += 10;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
                String possibility = dropdownEntry.getDisplayString();
                String displayPossibility = fontRenderer.func_78269_a(possibility, width);
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY);
                List<ITextComponent> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                WidgetTextFieldDropdown.fill((int)x, (int)(cy - 1), (int)(x + width), (int)(cy + entryHeight + 1), (int)-6250336);
                WidgetTextFieldDropdown.fill((int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + entryHeight), (int)-16777216);
                fontRenderer.func_175063_a(displayPossibility, (float)x + 1.0f, (float)cy + 2.0f, active ? this.enabledColor : this.disabledColor);
                if (addTooltip) {
                    int tooltipLineOffsetY = 2;
                    for (ITextComponent tooltipLine : tooltipLines) {
                        fontRenderer.func_175063_a(tooltipLine.func_150254_d(), (float)x + 1.0f, (float)cy + (float)(tooltipLineOffsetY += yOffset), this.enabledColor);
                    }
                }
                cy += entryHeight;
            }
            if (endIndex < this.visiblePossibilities.size()) {
                WidgetTextFieldDropdown.fill((int)x, (int)(cy - 1), (int)(x + width), (int)(cy + 11), (int)-6250336);
                WidgetTextFieldDropdown.fill((int)(x - 1), (int)cy, (int)(x + width - 1), (int)(cy + 10), (int)-16777216);
                fontRenderer.func_175063_a("...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.func_146176_q() && this.isFocused()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            fontRenderer.getClass();
            int yOffset = 9 + 3;
            int x = this.x;
            int y = this.y + yOffset;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            if (startIndex > 0) {
                cy += 10;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                boolean addTooltip;
                IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean bl = addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY);
                if (RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY)) {
                    this.selectVisiblePossibility(i);
                    return true;
                }
                List<ITextComponent> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                cy += entryHeight;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public IDropdownEntry<T> getSelectedDropdownPossibility() {
        return this.selectedDropdownPossibility;
    }

    public int getDropdownSize() {
        return this.dropdownSize;
    }

    public void setDropdownSize(int dropdownSize) {
        this.dropdownSize = dropdownSize;
    }

    public IDropdownEntryListener<T> getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setDropdownEntryListener(IDropdownEntryListener<T> dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }
}

