/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;

public class CastOperator<T1 extends IValueType<V1>, T2 extends IValueType<V2>, V1 extends IValue, V2 extends IValue>
extends OperatorBase {
    private final T1 from;
    private final T2 to;
    private final IValueCastRegistry.IMapping<T1, T2, V1, V2> mapping;

    public CastOperator(T1 from, T2 to, IValueCastRegistry.IMapping<T1, T2, V1, V2> mapping) {
        super("()", from.getTranslationKey() + "$" + to.getTranslationKey(), CastOperator.constructInputVariables(1, from), (IValueType)to, new OperatorBase.IFunction((IValueType)from, (IValueType)to, mapping){
            final /* synthetic */ IValueType val$from;
            final /* synthetic */ IValueType val$to;
            final /* synthetic */ IValueCastRegistry.IMapping val$mapping;
            {
                this.val$from = iValueType;
                this.val$to = iValueType2;
                this.val$mapping = iMapping;
            }

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                IValue value = variables.getValue(0);
                if (value.getType() != this.val$from) {
                    throw new EvaluationException((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.error.cast.unexpected", new Object[]{value.getType(), this.val$from, this.val$to}));
                }
                return this.val$mapping.cast(value);
            }
        }, IConfigRenderPattern.PREFIX_1);
        this.from = from;
        this.to = to;
        this.mapping = mapping;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integrateddynamics", "operator." + this.getModId() + ".cast" + this.from.getUniqueName().toString().replaceAll(":", "_") + "__" + this.to.getUniqueName().toString().replaceAll(":", "_"));
    }

    @Override
    public String getUnlocalizedType() {
        return "cast";
    }

    @Override
    protected String getUnlocalizedPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType();
    }

    @Override
    public void loadTooltip(List<ITextComponent> lines, boolean appendOptionalInfo) {
        lines.add((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.cast.tooltip", new Object[]{new TranslationTextComponent(this.from.getTranslationKey(), new Object[0]), new TranslationTextComponent(this.to.getTranslationKey(), new Object[0])}));
        super.loadTooltip(lines, appendOptionalInfo);
    }
}

