/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositioned;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyPositionedInventory
extends ValueTypeListProxyPositioned<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>
implements INBTProvider {
    public ValueTypeListProxyPositionedInventory(DimPos pos, Direction side) {
        super(ValueTypeListProxyFactories.POSITIONED_INVENTORY.getName(), ValueTypes.OBJECT_ITEMSTACK, pos, side);
    }

    public ValueTypeListProxyPositionedInventory() {
        this(null, null);
    }

    protected LazyOptional<IItemHandler> getInventory() {
        return TileHelpers.getCapability((DimPos)this.getPos(), (Direction)this.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    public int getLength() {
        return (Integer)this.getInventory().map(IItemHandler::getSlots).orElse((Object)0);
    }

    @Override
    public ValueObjectTypeItemStack.ValueItemStack get(int index) {
        return ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)this.getInventory().map(itemHandler -> itemHandler.getStackInSlot(index)).orElse((Object)ItemStack.field_190927_a));
    }

    @Override
    public Iterator<ValueObjectTypeItemStack.ValueItemStack> iterator() {
        return (Iterator)this.getInventory().map(itemHandler -> new ListFactoryIterator((IItemHandler)itemHandler)).orElse((Object)Iterators.forArray((Object[])new ValueObjectTypeItemStack.ValueItemStack[0]));
    }

    public static class ListFactoryIterator
    implements Iterator<ValueObjectTypeItemStack.ValueItemStack> {
        private final IItemHandler itemHandler;
        private int index = 0;

        public ListFactoryIterator(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public boolean hasNext() {
            return this.itemHandler != null && this.index < this.itemHandler.getSlots();
        }

        @Override
        public ValueObjectTypeItemStack.ValueItemStack next() {
            return ValueObjectTypeItemStack.ValueItemStack.of(this.itemHandler.getStackInSlot(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

