/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeOperatorLPElement;

public class ValueTypeOperator
extends ValueTypeBase<ValueOperator>
implements IValueTypeNamed<ValueOperator>,
IValueTypeUniquelyNamed<ValueOperator> {
    private static final String SIGNATURE_LINK = "->";

    public ValueTypeOperator() {
        super("operator", Helpers.RGBToInt((int)43, (int)231, (int)47), TextFormatting.DARK_GREEN, ValueOperator.class);
    }

    @Override
    public ValueOperator getDefault() {
        return ValueOperator.of(Operators.GENERAL_IDENTITY);
    }

    @Override
    public ITextComponent toCompactString(ValueOperator value) {
        return value.getRawValue().getLocalizedNameFull();
    }

    @Override
    public INBT serialize(ValueOperator value) {
        return Operators.REGISTRY.serialize(value.getRawValue());
    }

    @Override
    public ValueOperator deserialize(INBT value) {
        IOperator operator;
        try {
            operator = Operators.REGISTRY.deserialize(value);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (operator != null) {
            return ValueOperator.of(operator);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to an operator.", value));
    }

    @Override
    public void loadTooltip(List<ITextComponent> lines, boolean appendOptionalInfo, @Nullable ValueOperator value) {
        super.loadTooltip(lines, appendOptionalInfo, value);
        if (value != null) {
            lines.add(new TranslationTextComponent("valuetype.integrateddynamics.operator.tooltip.signature", new Object[0]).func_150257_a(ValueTypeOperator.getSignature(value.getRawValue())));
        }
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeOperatorLPElement();
    }

    @Override
    public ValueOperator materialize(ValueOperator value) throws EvaluationException {
        return ValueOperator.of(value.getRawValue().materialize());
    }

    public static ITextComponent getSignature(IOperator operator) {
        return (ITextComponent)ValueTypeOperator.getSignatureLines(operator, false).stream().reduce(new StringTextComponent(""), (a, b) -> a.func_150258_a(" ").func_150257_a(b));
    }

    public static String getSignature(IValueType[] inputTypes, IValueType outputType) {
        return StringUtils.join(ValueTypeOperator.getSignatureLines(inputTypes, outputType, false), (String)" ");
    }

    protected static ITextComponent switchSignatureLineContext(List<ITextComponent> lines, ITextComponent sb) {
        lines.add(sb);
        return new StringTextComponent("");
    }

    public static List<ITextComponent> getSignatureLines(IValueType[] inputTypes, IValueType outputType, boolean indent) {
        ArrayList lines = Lists.newArrayList();
        StringTextComponent sb = new StringTextComponent("");
        boolean first = true;
        for (IValueType inputType : inputTypes) {
            if (first) {
                first = false;
            } else {
                sb = ValueTypeOperator.switchSignatureLineContext(lines, (ITextComponent)sb);
                sb.func_150258_a((indent ? "  " : "") + SIGNATURE_LINK + " ");
            }
            sb.func_211708_a(inputType.getDisplayColorFormat()).func_150257_a((ITextComponent)new TranslationTextComponent(inputType.getTranslationKey(), new Object[0])).func_211708_a(TextFormatting.RESET);
        }
        sb = ValueTypeOperator.switchSignatureLineContext(lines, (ITextComponent)sb);
        sb.func_150258_a((indent ? "  " : "") + SIGNATURE_LINK + " ").func_211708_a(outputType.getDisplayColorFormat()).func_150257_a((ITextComponent)new TranslationTextComponent(outputType.getTranslationKey(), new Object[0])).func_211708_a(TextFormatting.RESET);
        ValueTypeOperator.switchSignatureLineContext(lines, (ITextComponent)sb);
        return lines;
    }

    public static List<ITextComponent> getSignatureLines(IOperator operator, boolean indent) {
        return ValueTypeOperator.getSignatureLines(operator.getInputTypes(), operator.getOutputType(), indent);
    }

    @Override
    public String getName(ValueOperator a) {
        return a.getRawValue().getLocalizedNameFull().getString();
    }

    @Override
    public String getUniqueName(ValueOperator a) {
        return a.getRawValue().getUniqueName().toString();
    }

    public static class ValueOperator
    extends ValueBase {
        private final IOperator value;

        private ValueOperator(IOperator value) {
            super(ValueTypes.OPERATOR);
            this.value = value;
        }

        public static ValueOperator of(IOperator value) {
            return new ValueOperator(value);
        }

        public IOperator getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ValueOperator && this.value.equals(((ValueOperator)o).value);
        }

        public int hashCode() {
            return 37 + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeOperator.ValueOperator(value=" + this.value + ")";
        }
    }
}

